/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.environment.locale;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.environment.AbstractLogAwareFacet;

public class LocaleFacet
extends AbstractLogAwareFacet {
    private Locale originalLocale;
    private Locale newLocale;

    public LocaleFacet(Log log, Locale newLocale) {
        super(log);
        Validate.notNull(newLocale, "usedLocale");
        this.originalLocale = Locale.getDefault();
        this.newLocale = newLocale;
    }

    @Override
    public void setup() {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Setting default locale to [" + String.valueOf(this.newLocale) + "]"));
        }
        try {
            Locale.setDefault(this.newLocale);
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Could not switch locale to [" + String.valueOf(this.newLocale) + "]. Continuing with standard locale."), (Throwable)e);
        }
    }

    @Override
    public void restore() {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Restoring default locale to [" + String.valueOf(this.originalLocale) + "]"));
        }
        try {
            Locale.setDefault(this.originalLocale);
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Could not restore locale to [" + String.valueOf(this.originalLocale) + "]. Continuing with [" + String.valueOf(Locale.getDefault()) + "]"), (Throwable)e);
        }
    }

    public static LocaleFacet createFor(String localeString, Log log) throws MojoExecutionException {
        Validate.notNull(log, "log");
        Validate.notEmpty(localeString, "localeString");
        StringTokenizer tok = new StringTokenizer(localeString, ",", false);
        int numTokens = tok.countTokens();
        if (numTokens > 3 || numTokens == 0) {
            throw new MojoExecutionException("A localeString must consist of up to 3 comma-separated parts on the form <language>[,<country>[,<variant>]]. Received incorrect value '" + localeString + "'");
        }
        String language = tok.nextToken().trim();
        String country = numTokens > 1 ? tok.nextToken().trim() : null;
        String variant = numTokens > 2 ? tok.nextToken().trim() : null;
        return new LocaleFacet(log, LocaleFacet.findOptimumLocale(language, country, variant));
    }

    public static Locale findOptimumLocale(String language, String country, String variant) {
        boolean hasCountry = country != null && !country.isEmpty();
        boolean hasVariant = variant != null && !variant.isEmpty();
        Locale[] availableLocales = Locale.getAvailableLocales();
        for (int i = 0; i < availableLocales.length; ++i) {
            boolean isVariantMatch;
            Locale current = availableLocales[i];
            String currentLanguage = current.getLanguage();
            String currentCountry = current.getCountry();
            String currentVariant = current.getVariant();
            boolean isLanguageMatch = language.equalsIgnoreCase(currentLanguage);
            boolean isCountryMatch = hasCountry && country.equalsIgnoreCase(currentCountry) || !hasCountry && (currentCountry == null || currentCountry.isEmpty());
            boolean bl = isVariantMatch = hasVariant && variant.equalsIgnoreCase(currentVariant) || !hasVariant && (currentVariant == null || currentVariant.isEmpty());
            if (!isLanguageMatch || !isCountryMatch || !isVariantMatch) continue;
            return current;
        }
        return Locale.getDefault();
    }
}

