/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.schemageneration.AbstractXsdGeneratorMojo;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;
import org.codehaus.mojo.jaxb2.shared.filters.Filters;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.PatternFileFilter;

@Mojo(name="schemagen", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class SchemaGenerationMojo
extends AbstractXsdGeneratorMojo {
    public static final String STALE_FILENAME = "schemaGenerationStaleFlag";
    public static final List<Filter<File>> STANDARD_SOURCE_EXCLUDE_FILTERS;
    @Parameter(required=false)
    private List<String> sources;
    @Parameter(required=false)
    private List<Filter<File>> schemaSourceExcludeFilters;
    @Parameter(defaultValue="${project.build.directory}/generated-resources/schemagen", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/schemagen-work/compile_scope", required=true)
    private File workDirectory;

    @Override
    protected List<URL> getCompiledClassNames() {
        List<Filter<File>> excludeFilters = this.schemaSourceExcludeFilters == null ? STANDARD_BYTECODE_EXCLUDE_FILTERS : this.schemaSourceExcludeFilters;
        Filters.initialize(this.getLog(), excludeFilters);
        try {
            return FileSystemUtilities.filterFiles(this.getProject().getBasedir(), null, this.getProject().getCompileClasspathElements(), this.getLog(), "compiled bytecode", excludeFilters);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Could not resolve dependencies.", e);
        }
    }

    @Override
    protected List<URL> getSources() {
        List<Filter<File>> sourceExcludes = this.schemaSourceExcludeFilters == null ? STANDARD_SOURCE_EXCLUDE_FILTERS : this.schemaSourceExcludeFilters;
        Filters.initialize(this.getLog(), sourceExcludes);
        List<String> defaultSources = this.getProject().getCompileSourceRoots();
        return FileSystemUtilities.filterFiles(this.getProject().getBasedir(), this.sources == null ? defaultSources : this.sources, defaultSources, this.getLog(), "sources", sourceExcludes);
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected List<String> getClasspath() throws MojoExecutionException {
        List toReturn = null;
        try {
            toReturn = this.getProject().getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not acquire compile classpath elements from MavenProject", (Exception)((Object)e));
        }
        return toReturn;
    }

    @Override
    protected void addGeneratedSourcesToProjectSourceRoot(String canonicalPathToOutputDirectory) {
        this.getProject().addCompileSourceRoot(canonicalPathToOutputDirectory);
    }

    @Override
    protected String getStaleFileName() {
        return STALE_FILENAME;
    }

    @Override
    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    protected void addResource(Resource resource) {
        if (resource != null) {
            String newDirectory = resource.getDirectory();
            List currentResources = this.getProject().getResources();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Candidate Resource Directory [" + newDirectory + "]"));
                this.getLog().debug((CharSequence)("Found [" + currentResources.size() + "] current Resources: " + currentResources));
            }
            for (Resource current : currentResources) {
                if (current.getDirectory() == null || !current.getDirectory().equalsIgnoreCase(newDirectory)) continue;
                this.getLog().debug((CharSequence)("Resource already added [" + newDirectory + "]. Not adding again."));
                return;
            }
            currentResources.add(resource);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Added resource [" + newDirectory + "] to existing resources."));
            }
        }
    }

    static {
        ArrayList<Filter<File>> srcTemp = new ArrayList<Filter<File>>();
        srcTemp.addAll(AbstractJaxbMojo.STANDARD_EXCLUDE_FILTERS);
        srcTemp.add(new PatternFileFilter(Arrays.asList("\\.xjb", "\\.xsd", "\\.properties"), true));
        STANDARD_SOURCE_EXCLUDE_FILTERS = Collections.unmodifiableList(srcTemp);
    }
}

