/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten.model.resolution;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.project.MavenProject;

class ReactorModelPool {
    private Map<Coordinates, File> models = new HashMap<Coordinates, File>();

    ReactorModelPool() {
    }

    public File find(String groupId, String artifactId, String version) {
        return this.models.get(new Coordinates(groupId, artifactId, version));
    }

    public void addProjects(List<MavenProject> projects) {
        for (MavenProject project : projects) {
            this.addProject(project);
        }
    }

    public void addProject(MavenProject project) {
        Coordinates coordinates = new Coordinates(project.getGroupId(), project.getArtifactId(), project.getVersion());
        this.models.put(coordinates, project.getFile());
    }

    private static final class Coordinates {
        final String groupId;
        final String artifactId;
        final String version;

        Coordinates(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Coordinates) {
                Coordinates other = (Coordinates)obj;
                return this.artifactId.equals(other.artifactId) && this.groupId.equals(other.groupId) && this.version.equals(other.version);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.artifactId, this.groupId, this.version);
        }
    }
}

