/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.AbstractProperty;
import org.codehaus.mojo.exec.ProjectProperties;
import org.codehaus.mojo.exec.Property;
import org.codehaus.mojo.exec.SystemExitException;
import org.codehaus.mojo.exec.URLClassLoaderBuilder;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

@Mojo(name="java", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ExecJavaMojo
extends AbstractExecMojo {
    private static final String THREAD_STOP_UNAVAILABLE = "Thread.stop() is unavailable in this JRE version, cannot force-stop any threads";
    @org.apache.maven.plugins.annotations.Parameter(required=true, property="exec.mainClass")
    private String mainClass;
    @org.apache.maven.plugins.annotations.Parameter(property="exec.preloadCommonPool", defaultValue="0")
    private int preloadCommonPool;
    @org.apache.maven.plugins.annotations.Parameter(property="exec.arguments")
    private String[] arguments;
    @org.apache.maven.plugins.annotations.Parameter
    private AbstractProperty[] systemProperties;
    @Deprecated
    @org.apache.maven.plugins.annotations.Parameter(property="exec.keepAlive", defaultValue="false")
    private boolean keepAlive;
    @org.apache.maven.plugins.annotations.Parameter(property="exec.includeProjectDependencies", defaultValue="true")
    private boolean includeProjectDependencies;
    @org.apache.maven.plugins.annotations.Parameter(property="exec.cleanupDaemonThreads", defaultValue="true")
    private boolean cleanupDaemonThreads;
    @org.apache.maven.plugins.annotations.Parameter(property="exec.daemonThreadJoinTimeout", defaultValue="15000")
    private long daemonThreadJoinTimeout;
    @org.apache.maven.plugins.annotations.Parameter(property="exec.stopUnresponsiveDaemonThreads", defaultValue="false")
    private boolean stopUnresponsiveDaemonThreads;
    private Properties originalSystemProperties;
    @org.apache.maven.plugins.annotations.Parameter
    private List<String> additionalClasspathElements;
    @org.apache.maven.plugins.annotations.Parameter
    private List<String> classpathFilenameExclusions;
    @org.apache.maven.plugins.annotations.Parameter
    private List<String> forcedJvmPackages;
    @org.apache.maven.plugins.annotations.Parameter
    private List<String> excludedJvmPackages;
    @org.apache.maven.plugins.annotations.Parameter(property="exec.blockSystemExit", defaultValue="false")
    private boolean blockSystemExit;
    private final PlexusContainer container;

    @Inject
    protected ExecJavaMojo(RepositorySystem repositorySystem, PlexusContainer container) {
        super(repositorySystem);
        this.container = Objects.requireNonNull(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skipping execute as per configuration");
            return;
        }
        if (null == this.arguments) {
            this.arguments = new String[0];
        }
        if (this.getLog().isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("Invoking : ");
            msg.append(this.mainClass);
            msg.append(".main(");
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(this.arguments[i]);
            }
            msg.append(")");
            this.getLog().debug((CharSequence)msg);
        }
        if (this.preloadCommonPool >= 0) {
            this.preloadCommonPool();
        }
        IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(this.mainClass);
        Thread bootstrapThread = new Thread(threadGroup, () -> {
            int sepIndex = this.mainClass.indexOf(47);
            String bootClassName = sepIndex >= 0 ? this.mainClass.substring(sepIndex + 1) : this.mainClass;
            try {
                this.doExec(bootClassName);
            }
            catch (IllegalAccessException | NoSuchMethodError | NoSuchMethodException e) {
                Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), new Exception("The specified mainClass doesn't contain a main method with appropriate signature.", e));
            }
            catch (InvocationTargetException e) {
                Throwable exceptionToReport = e.getCause() != null ? e.getCause() : e;
                Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), exceptionToReport);
            }
            catch (SystemExitException systemExitException) {
                if (systemExitException.getExitCode() != 0) {
                    this.getLog().error((CharSequence)systemExitException.getMessage());
                    throw systemExitException;
                }
                this.getLog().info((CharSequence)systemExitException.getMessage());
            }
            catch (Throwable e) {
                Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
            }
        }, this.mainClass + ".main()");
        URLClassLoader classLoader = this.getClassLoader();
        bootstrapThread.setContextClassLoader(classLoader);
        this.setSystemProperties();
        bootstrapThread.start();
        this.joinNonDaemonThreads(threadGroup);
        if (this.keepAlive) {
            this.getLog().warn((CharSequence)"Warning: keepAlive is now deprecated and obsolete. Do you need it? Please comment on MEXEC-6.");
            this.waitFor(0L);
        }
        if (this.cleanupDaemonThreads) {
            this.terminateThreads(threadGroup);
            try {
                threadGroup.destroy();
            }
            catch (Error | RuntimeException e) {
                this.getLog().warn((CharSequence)("Couldn't destroy threadgroup " + threadGroup), e);
            }
        }
        if (classLoader != null) {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        if (this.originalSystemProperties != null) {
            System.setProperties(this.originalSystemProperties);
        }
        IsolatedThreadGroup isolatedThreadGroup = threadGroup;
        synchronized (isolatedThreadGroup) {
            if (threadGroup.uncaughtException != null) {
                throw new MojoExecutionException("An exception occurred while executing the Java class. " + threadGroup.uncaughtException.getMessage(), threadGroup.uncaughtException);
            }
        }
        this.registerSourceRoots();
    }

    private void doExec(String bootClassName) throws Throwable {
        Class<?> bootClass = Thread.currentThread().getContextClassLoader().loadClass(bootClassName);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle mainHandle = lookup.findStatic(bootClass, "main", MethodType.methodType(Void.TYPE, String[].class));
            mainHandle.invoke(this.arguments);
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException mainHandle) {
            try {
                MethodHandle mainHandle2 = lookup.findVirtual(bootClass, "main", MethodType.methodType(Void.TYPE, String[].class));
                mainHandle2.invoke(this.newInstance(bootClass), this.arguments);
                return;
            }
            catch (IllegalAccessException | NoSuchMethodException mainHandle2) {
                try {
                    MethodHandle mainHandle3 = lookup.findStatic(bootClass, "main", MethodType.methodType(Void.TYPE));
                    mainHandle3.invoke();
                    return;
                }
                catch (IllegalAccessException | NoSuchMethodException mainHandle3) {
                    try {
                        MethodHandle mainHandle4 = lookup.findVirtual(bootClass, "main", MethodType.methodType(Void.TYPE));
                        mainHandle4.invoke(this.newInstance(bootClass));
                        return;
                    }
                    catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                        if (Runnable.class.isAssignableFrom(bootClass)) {
                            this.doRun(bootClass);
                            return;
                        }
                        throw new NoSuchMethodException("No suitable main method found for " + bootClass + ", and not Runnable");
                    }
                }
            }
        }
    }

    private Object newInstance(Class<?> bootClass) throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        Constructor<?> constructor = bootClass.getDeclaredConstructor(new Class[0]);
        if ((constructor.getModifiers() & 2) != 0) {
            throw new NoSuchMethodException("No public constructor found for " + bootClass);
        }
        return constructor.newInstance(new Object[0]);
    }

    private void doRun(Class<?> bootClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Runnable runnable;
        Class<Runnable> runnableClass = bootClass.asSubclass(Runnable.class);
        Constructor constructor = Stream.of(runnableClass.getDeclaredConstructors()).map(i -> i).filter(i -> Modifier.isPublic(i.getModifiers())).max(Comparator.comparing(Constructor::getParameterCount)).orElseThrow(() -> new IllegalArgumentException("No public constructor found for " + bootClass));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using constructor " + constructor));
        }
        try {
            Object[] args = Stream.of(constructor.getParameters()).map(param -> {
                try {
                    return this.lookupParam((Parameter)param);
                }
                catch (ComponentLookupException e) {
                    this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }).toArray(Object[]::new);
            constructor.setAccessible(true);
            runnable = (Runnable)constructor.newInstance(args);
        }
        catch (RuntimeException re) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Can't inject " + runnableClass + "': " + re.getMessage() + ", will ignore injections"), (Throwable)re);
            }
            Constructor<Runnable> declaredConstructor = runnableClass.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            runnable = declaredConstructor.newInstance(new Object[0]);
        }
        runnable.run();
    }

    private Object lookupParam(Parameter param) throws ComponentLookupException {
        String name;
        switch (name = param.getName()) {
            case "systemProperties": {
                return this.getSession().getSystemProperties();
            }
            case "systemPropertiesUpdater": {
                return this.propertiesUpdater(this.getSession().getSystemProperties());
            }
            case "userProperties": {
                return this.getSession().getUserProperties();
            }
            case "userPropertiesUpdater": {
                return this.propertiesUpdater(this.getSession().getUserProperties());
            }
            case "projectProperties": {
                return this.project.getProperties();
            }
            case "projectPropertiesUpdater": {
                return this.propertiesUpdater(this.project.getProperties());
            }
            case "highestVersionResolver": {
                return this.resolveVersion(VersionRangeResult::getHighestVersion);
            }
            case "session": {
                return this.getSession();
            }
            case "container": {
                return this.container;
            }
        }
        return this.lookup(param, name);
    }

    private Object lookup(Parameter param, String name) throws ComponentLookupException {
        block4: {
            if (param.getType() == Object.class && name.contains("_")) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    int hintIdx = name.indexOf("__hint_");
                    if (hintIdx > 0) {
                        String hint = name.substring(hintIdx + "__hint_".length());
                        String typeName = name.substring(0, hintIdx).replace('_', '.');
                        return this.container.lookup(loader.loadClass(typeName), hint);
                    }
                    String typeName = name.replace('_', '.');
                    return this.container.lookup(loader.loadClass(typeName));
                }
                catch (ClassNotFoundException cnfe) {
                    if (!this.getLog().isDebugEnabled()) break block4;
                    this.getLog().debug((CharSequence)("Can't load param (" + name + "): " + cnfe.getMessage()), (Throwable)cnfe);
                }
            }
        }
        return this.container.lookup(param.getType());
    }

    private Function<String, String> resolveVersion(Function<VersionRangeResult, Object> fn) {
        return ga -> {
            int sep = ga.indexOf(58);
            if (sep < 0) {
                throw new IllegalArgumentException("Invalid groupId:artifactId argument: '" + ga + "'");
            }
            DefaultArtifact artifact = new DefaultArtifact(ga + ":[0,)");
            VersionRangeRequest rangeRequest = new VersionRangeRequest();
            rangeRequest.setArtifact((org.eclipse.aether.artifact.Artifact)artifact);
            try {
                if (this.includePluginDependencies && this.includeProjectDependencies) {
                    rangeRequest.setRepositories(Stream.concat(this.project.getRemoteProjectRepositories().stream(), this.project.getRemotePluginRepositories().stream()).distinct().collect(Collectors.toList()));
                } else if (this.includePluginDependencies) {
                    rangeRequest.setRepositories(this.project.getRemotePluginRepositories());
                } else if (this.includeProjectDependencies) {
                    rangeRequest.setRepositories(this.project.getRemoteProjectRepositories());
                }
                VersionRangeResult rangeResult = this.repositorySystem.resolveVersionRange(this.getSession().getRepositorySession(), rangeRequest);
                return String.valueOf(fn.apply(rangeResult));
            }
            catch (VersionRangeResolutionException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    private BiConsumer<String, String> propertiesUpdater(Properties props) {
        return (k, v) -> {
            if (v == null) {
                props.remove(k);
            } else {
                props.setProperty((String)k, (String)v);
            }
        };
    }

    private void preloadCommonPool() {
        try {
            ForkJoinPool es = ForkJoinPool.commonPool();
            int max = this.preloadCommonPool > 0 ? this.preloadCommonPool : ForkJoinPool.getCommonPoolParallelism();
            CountDownLatch preLoad = new CountDownLatch(1);
            for (int i = 0; i < max; ++i) {
                es.submit(() -> {
                    try {
                        preLoad.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
            preLoad.countDown();
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)(e.getMessage() + ", skipping commonpool earger init"));
        }
    }

    private void joinNonDaemonThreads(ThreadGroup threadGroup) {
        boolean foundNonDaemon;
        do {
            foundNonDaemon = false;
            Collection<Thread> threads = this.getActiveThreads(threadGroup);
            for (Thread thread : threads) {
                if (thread.isDaemon()) continue;
                foundNonDaemon = true;
                this.joinThread(thread, 0L);
            }
        } while (foundNonDaemon);
    }

    private void joinThread(Thread thread, long timeoutMsecs) {
        try {
            this.getLog().debug((CharSequence)("joining on thread " + thread));
            thread.join(timeoutMsecs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLog().warn((CharSequence)("interrupted while joining against thread " + thread), (Throwable)e);
        }
        if (thread.isAlive()) {
            this.getLog().warn((CharSequence)("thread " + thread + " was interrupted but is still alive after waiting at least " + timeoutMsecs + "msecs"));
        }
    }

    private void terminateThreads(ThreadGroup threadGroup) {
        long startTime = System.currentTimeMillis();
        HashSet<Thread> uncooperativeThreads = new HashSet<Thread>();
        Collection<Thread> threads = this.getActiveThreads(threadGroup);
        while (!threads.isEmpty()) {
            for (Thread thread : threads) {
                this.getLog().debug((CharSequence)("interrupting thread " + thread));
                thread.interrupt();
            }
            boolean threadStopIsAvailable = true;
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                if (this.daemonThreadJoinTimeout <= 0L) {
                    this.joinThread(thread, 0L);
                    continue;
                }
                long timeout = this.daemonThreadJoinTimeout - (System.currentTimeMillis() - startTime);
                if (timeout > 0L) {
                    this.joinThread(thread, timeout);
                }
                if (!thread.isAlive()) continue;
                uncooperativeThreads.add(thread);
                if (this.stopUnresponsiveDaemonThreads && threadStopIsAvailable) {
                    this.getLog().warn((CharSequence)("thread " + thread + " will be Thread.stop()'ed"));
                    try {
                        thread.stop();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        threadStopIsAvailable = false;
                        this.getLog().warn((CharSequence)THREAD_STOP_UNAVAILABLE);
                    }
                    continue;
                }
                this.getLog().warn((CharSequence)("thread " + thread + " will linger despite being asked to die via interruption"));
            }
            threads = this.getActiveThreads(threadGroup);
            threads.removeAll(uncooperativeThreads);
        }
        if (!uncooperativeThreads.isEmpty()) {
            this.getLog().warn((CharSequence)("NOTE: " + uncooperativeThreads.size() + " thread(s) did not finish despite being asked to via interruption. This is not a problem with exec:java, it is a problem with the running code. Although not serious, it should be remedied."));
        } else {
            int activeCount = threadGroup.activeCount();
            if (activeCount != 0) {
                Thread[] threadsArray = new Thread[1];
                threadGroup.enumerate(threadsArray);
                this.getLog().debug((CharSequence)("strange; " + activeCount + " thread(s) still active in the group " + threadGroup + " such as " + threadsArray[0]));
            }
        }
    }

    private Collection<Thread> getActiveThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads);
        ArrayList<Thread> result = new ArrayList<Thread>(numThreads);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            result.add(threads[i]);
        }
        return result;
    }

    private void setSystemProperties() {
        if (this.systemProperties == null) {
            return;
        }
        this.originalSystemProperties = new Properties();
        this.originalSystemProperties.putAll((Map<?, ?>)System.getProperties());
        if (Stream.of(this.systemProperties).anyMatch(it -> it instanceof ProjectProperties)) {
            System.getProperties().putAll((Map<?, ?>)this.project.getProperties());
        }
        for (AbstractProperty systemProperty : this.systemProperties) {
            if (!(systemProperty instanceof Property)) continue;
            Property prop = (Property)systemProperty;
            String value = prop.getValue();
            System.setProperty(prop.getKey(), value == null ? "" : value);
        }
    }

    private URLClassLoader getClassLoader() throws MojoExecutionException {
        ArrayList<Path> classpathURLs = new ArrayList<Path>();
        this.addRelevantPluginDependenciesToClasspath(classpathURLs);
        this.addRelevantProjectDependenciesToClasspath(classpathURLs);
        this.addAdditionalClasspathElements(classpathURLs);
        try {
            return URLClassLoaderBuilder.builder().setLogger(this.getLog()).setPaths(classpathURLs).setExclusions(this.classpathFilenameExclusions).setForcedJvmPackages(this.forcedJvmPackages).setExcludedJvmPackages(this.excludedJvmPackages).withTransformers(this.blockSystemExit).build();
        }
        catch (IOException | NullPointerException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void addAdditionalClasspathElements(List<Path> path) {
        if (this.additionalClasspathElements != null) {
            for (String classPathElement : this.additionalClasspathElements) {
                Path file = Paths.get(classPathElement, new String[0]);
                if (!file.isAbsolute()) {
                    file = this.project.getBasedir().toPath().resolve(file);
                }
                this.getLog().debug((CharSequence)("Adding additional classpath element: " + file + " to classpath"));
                path.add(file);
            }
        }
    }

    private void addRelevantPluginDependenciesToClasspath(List<Path> path) throws MojoExecutionException {
        if (this.hasCommandlineArgs()) {
            this.arguments = this.parseCommandlineArgs();
        }
        for (Artifact classPathElement : this.determineRelevantPluginDependencies()) {
            this.getLog().debug((CharSequence)("Adding plugin dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
            path.add(classPathElement.getFile().toPath());
        }
    }

    private void addRelevantProjectDependenciesToClasspath(List<Path> path) {
        if (this.includeProjectDependencies) {
            this.getLog().debug((CharSequence)"Project Dependencies will be included.");
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            ArrayList<Path> theClasspathFiles = new ArrayList<Path>();
            this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
            for (Path classpathFile : theClasspathFiles) {
                this.getLog().debug((CharSequence)("Adding to classpath : " + classpathFile));
                path.add(classpathFile);
            }
            for (Artifact classPathElement : artifacts) {
                this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                path.add(classPathElement.getFile().toPath());
            }
        } else {
            this.getLog().debug((CharSequence)"Project Dependencies will be excluded.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(long millis) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.getLog().warn((CharSequence)("Spuriously interrupted while waiting for " + millis + "ms"), (Throwable)e);
            }
        }
    }

    class IsolatedThreadGroup
    extends ThreadGroup {
        private Throwable uncaughtException;

        public IsolatedThreadGroup(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            IsolatedThreadGroup isolatedThreadGroup = this;
            synchronized (isolatedThreadGroup) {
                if (this.uncaughtException == null) {
                    this.uncaughtException = throwable;
                }
            }
            ExecJavaMojo.this.getLog().warn(throwable);
        }
    }
}

