/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dita;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.dita.AbstractProjectMojo;
import org.codehaus.plexus.util.IOUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DitaEclipseMojo
extends AbstractProjectMojo {
    private String projectName;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipped");
            return;
        }
        File eclipseProjectFile = new File(this.project.getBasedir(), ".project");
        if (!eclipseProjectFile.exists()) {
            this.generateBrandNewEclipseProjectFile(eclipseProjectFile);
            return;
        }
        this.addDitaOpenPlatformToCurrentEclipseProject(eclipseProjectFile);
    }

    private void addDitaOpenPlatformToCurrentEclipseProject(File eclipseProjectFile) throws MojoExecutionException {
        Document doc = DocumentFactory.getInstance().createDocument();
        try {
            SAXReader saxReader = new SAXReader();
            doc = saxReader.read(eclipseProjectFile);
            this.addDitaBuildCommand(doc);
            this.addDitaBuildNature(doc);
        }
        catch (DocumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.writeOutEclipseProject(doc, eclipseProjectFile);
    }

    private void addDitaBuildCommand(Document doc) {
        Element buildSpec = (Element)doc.selectSingleNode("//projectDescription/buildSpec");
        boolean foundDitaBuildCommand = false;
        Iterator i = buildSpec.elementIterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            if (!"buildCommand".equals(element.getName())) continue;
            Iterator j = element.elementIterator();
            while (j.hasNext()) {
                Element buildCommandChildElement = (Element)j.next();
                if (!"name".equals(buildCommandChildElement.getName()) || !"org.dita_op.editor.DITAFileValidator".equals(buildCommandChildElement.getText())) continue;
                foundDitaBuildCommand = true;
            }
        }
        if (!foundDitaBuildCommand) {
            this.addDitaBuildCommand(buildSpec);
        }
    }

    private void addDitaBuildCommand(Element buildSpec) {
        Element buildCommand = buildSpec.addElement("buildCommand");
        buildCommand.addElement("name").setText("org.dita_op.editor.DITAFileValidator");
        buildCommand.addElement("arguments");
    }

    private void addDitaBuildNature(Document doc) {
        Element natures = (Element)doc.selectSingleNode("//projectDescription/natures");
        boolean foundDitaBuildNature = false;
        Iterator i = natures.elementIterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            if (!"nature".equals(element.getName()) || !"org.dita_op.editor.DITAProjectNature".equals(element.getText())) continue;
            foundDitaBuildNature = true;
        }
        if (!foundDitaBuildNature) {
            this.addDitaBuildNature(natures);
        }
    }

    private void generateBrandNewEclipseProjectFile(File eclipseProjectFile) throws MojoExecutionException {
        Document doc = DocumentFactory.getInstance().createDocument();
        Element root = doc.addElement("projectDescription");
        root.addElement("name").setText(this.projectName);
        root.addElement("comment");
        root.addElement("projects");
        this.addDitaBuildCommand(root.addElement("buildSpec"));
        this.addDitaBuildNature(root.addElement("natures"));
        this.writeOutEclipseProject(doc, eclipseProjectFile);
    }

    private void addDitaBuildNature(Element natures) {
        natures.addElement("nature").setText("org.dita_op.editor.DITAProjectNature");
    }

    private void writeOutEclipseProject(Document doc, File file) throws MojoExecutionException {
        FileWriter fileWriter = null;
        try {
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            fileWriter = new FileWriter(file);
            XMLWriter writer = new XMLWriter((Writer)fileWriter, outformat);
            writer.write(doc);
            writer.flush();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileWriter);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fileWriter);
    }
}

