/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dita;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.mojo.dita.AbstractProjectMojo;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractDitaMojo
extends AbstractProjectMojo {
    protected boolean useDitaClasspath;
    protected Map<String, String> antProperties = new HashMap<String, String>();
    private List<String> classpathElements;
    private MojoExecution mojoExecution;
    protected File ditaDirectory;

    protected void setupDitaDirectory() throws MojoExecutionException {
        if (this.antProperties.get("dita.dir") == null) {
            this.antProperties.put("dita.dir", System.getenv("DITA_HOME"));
        }
        if (this.antProperties.get("dita.dir") == null) {
            throw new MojoExecutionException("antProperties' dita.dir or env.DITA_HOME configuration not set.");
        }
        this.ditaDirectory = new File(this.antProperties.get("dita.dir"));
        if (!this.ditaDirectory.isDirectory()) {
            throw new MojoExecutionException("DITA Open Toolkit at " + this.ditaDirectory + " not found. ");
        }
    }

    protected void setupClasspathEnv(Commandline cl) {
        String classpath = this.buildClasspathString();
        cl.addEnvironment("CLASSPATH", classpath);
        this.getLog().info((CharSequence)("CLASSPATH: " + classpath));
    }

    protected String buildClasspathString() {
        StringBuilder classpath = new StringBuilder();
        List artifacts = this.mojoExecution.getMojoDescriptor().getPluginDescriptor().getArtifacts();
        for (Artifact artifact : artifacts) {
            classpath.append(artifact.getFile()).append(File.pathSeparator);
        }
        for (String cpElement : this.classpathElements) {
            if (!cpElement.endsWith(".jar")) continue;
            classpath.append(cpElement).append(File.pathSeparator);
        }
        File ditaLibDir = new File(this.ditaDirectory.getAbsolutePath(), "lib");
        classpath.append(ditaLibDir.getAbsolutePath()).append(File.pathSeparator);
        if (this.useDitaClasspath) {
            FileSetManager fileSetManager = new FileSetManager(this.getLog(), false);
            FileSet fileSet = new FileSet();
            fileSet.setDirectory(this.ditaDirectory.getAbsolutePath() + "/lib");
            ArrayList<String> includes = new ArrayList<String>();
            includes.add("**/*.jar");
            fileSet.setIncludes(includes);
            String[] files = fileSetManager.getIncludedFiles(fileSet);
            for (int i = 0; i < files.length; ++i) {
                File jarFile = new File(fileSet.getDirectory(), files[i]);
                classpath.append(jarFile.getAbsolutePath()).append(File.pathSeparator);
            }
        }
        return classpath.toString();
    }

    protected void setupDitaMainClass(Commandline cl) {
        cl.createArg().setValue("org.dita.dost.invoker.CommandLineInvoker");
    }
}

