/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart.time;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.codehaus.mojo.dashboard.report.plugin.beans.SurefireReportBean;
import org.codehaus.mojo.dashboard.report.plugin.chart.AbstractChartDecorator;
import org.codehaus.mojo.dashboard.report.plugin.chart.IChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.chart.time.TimeChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.utils.ChartUtils;
import org.codehaus.mojo.dashboard.report.plugin.utils.TimePeriod;
import org.jfree.chart.ChartColor;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class SurefirePercentAxisDecorator
extends AbstractChartDecorator {
    private static final double BLOCK_CONTAINER_WIDTH = 2000.0;
    private static final int ITEM_LABEL_FONT_SIZE = 10;
    private static final double AXIS_UPPER_MARGIN = 0.099;
    private static final int PCENT = 100;

    public SurefirePercentAxisDecorator(IChartRenderer chartToDecorate, List results) {
        super(chartToDecorate, results);
    }

    public void createChart() {
        XYPlot xyplot = (XYPlot)this.report.getPlot();
        if (this.decoratedChart instanceof TimeChartRenderer && this.results != null && !this.results.isEmpty()) {
            Iterator iter = this.results.iterator();
            TimeSeriesCollection defaultdataset = new TimeSeriesCollection();
            TimeSeries s1 = new TimeSeries("% success", Day.class);
            while (iter.hasNext()) {
                SurefireReportBean surefire = (SurefireReportBean)iter.next();
                Date date = surefire.getDateGeneration();
                s1.addOrUpdate((RegularTimePeriod)new Day(TimePeriod.DAY.normalize(date)), surefire.getSucessRate() / 100.0);
            }
            defaultdataset.addSeries(s1);
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            renderer.setSeriesPaint(0, (Paint)ChartColor.DARK_BLUE);
            renderer.setShapesVisible(true);
            renderer.setDrawOutlines(true);
            StandardXYItemLabelGenerator labelgenerator = new StandardXYItemLabelGenerator("{2}", (DateFormat)TimePeriod.DAY.getDateFormat(), NumberFormat.getPercentInstance(Locale.getDefault()));
            renderer.setBaseItemLabelGenerator((XYItemLabelGenerator)labelgenerator);
            renderer.setItemLabelFont(new Font("SansSerif", 1, 10));
            renderer.setBaseItemLabelsVisible(true);
            renderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE10, TextAnchor.BASELINE_RIGHT));
            renderer.setBaseStroke((Stroke)new BasicStroke(2.0f, 1, 1));
            LegendTitle legendtitle = new LegendTitle((LegendItemSource)xyplot.getRenderer(0));
            legendtitle.setMargin(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
            legendtitle.setFrame((BlockFrame)new BlockBorder());
            legendtitle.setBackgroundPaint((Paint)ChartColor.WHITE);
            LegendTitle legendtitle1 = new LegendTitle((LegendItemSource)renderer);
            legendtitle1.setMargin(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
            legendtitle1.setFrame((BlockFrame)new BlockBorder());
            legendtitle1.setBackgroundPaint((Paint)ChartColor.WHITE);
            BlockContainer blockcontainer = new BlockContainer((Arrangement)new BorderArrangement());
            blockcontainer.add((Block)legendtitle, (Object)RectangleEdge.LEFT);
            blockcontainer.add((Block)legendtitle1, (Object)RectangleEdge.RIGHT);
            blockcontainer.add((Block)new EmptyBlock(2000.0, 0.0));
            CompositeTitle compositetitle = new CompositeTitle(blockcontainer);
            compositetitle.setPosition(RectangleEdge.BOTTOM);
            this.report.clearSubtitles();
            this.report.addSubtitle((Title)compositetitle);
            xyplot.setDataset(1, (XYDataset)defaultdataset);
            NumberAxis valueaxis = new NumberAxis("% success");
            valueaxis.setLowerMargin(0.0);
            valueaxis.setUpperMargin(0.099);
            valueaxis.setRangeWithMargins(0.0, 1.0);
            valueaxis.setNumberFormatOverride(NumberFormat.getPercentInstance());
            xyplot.setRangeAxis(1, (ValueAxis)valueaxis);
            xyplot.mapDatasetToRangeAxis(1, 1);
            xyplot.setRenderer(1, (XYItemRenderer)renderer);
        }
    }

    public Color getBackgroundColor() {
        return (Color)ChartUtils.BLUE_STEEL2_LIGHT;
    }
}

