/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart;

import java.awt.Color;
import java.awt.Paint;
import java.text.NumberFormat;
import org.codehaus.mojo.dashboard.report.plugin.chart.AbstractChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.chart.CloverBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.IChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.MultiCloverBarChartStrategy;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class StackedBarChartRenderer
extends AbstractChartRenderer {
    private static final double NUMBER_AXIS_RANGE = 1.0;

    public StackedBarChartRenderer(IChartStrategy strategy) {
        super(strategy);
    }

    public StackedBarChartRenderer(IChartStrategy strategy, int width, int height) {
        super(strategy, width, height);
    }

    public void createChart() {
        CategoryDataset categorydataset = (CategoryDataset)this.datasetStrategy.getDataset();
        this.report = ChartFactory.createStackedBarChart((String)this.datasetStrategy.getTitle(), (String)this.datasetStrategy.getYAxisLabel(), (String)this.datasetStrategy.getXAxisLabel(), (CategoryDataset)categorydataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        this.report.setAntiAlias(false);
        this.report.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        CategoryPlot categoryplot = (CategoryPlot)this.report.getPlot();
        categoryplot.setBackgroundPaint((Paint)Color.white);
        categoryplot.setRangeGridlinePaint((Paint)Color.lightGray);
        NumberAxis numberaxis = (NumberAxis)categoryplot.getRangeAxis();
        if (this.datasetStrategy instanceof CloverBarChartStrategy || this.datasetStrategy instanceof MultiCloverBarChartStrategy) {
            numberaxis.setRange(0.0, 1.0);
            numberaxis.setNumberFormatOverride(NumberFormat.getPercentInstance());
        } else {
            numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        }
        numberaxis.setLowerMargin(0.0);
        StackedBarRenderer stackedbarrenderer = (StackedBarRenderer)categoryplot.getRenderer();
        stackedbarrenderer.setDrawBarOutline(false);
        stackedbarrenderer.setItemLabelsVisible(true);
        stackedbarrenderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        stackedbarrenderer.setItemLabelFont(StackedBarRenderer.DEFAULT_VALUE_LABEL_FONT.deriveFont(1));
        int height = categorydataset.getColumnCount() * 13 * 2 + 40 + 10;
        if (height > 300) {
            super.setHeight(height);
        } else {
            super.setHeight(300);
        }
        Paint[] paints = this.datasetStrategy.getPaintColor();
        for (int i = 0; i < categorydataset.getRowCount() && i < paints.length; ++i) {
            stackedbarrenderer.setSeriesPaint(i, paints[i]);
        }
    }
}

