/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.chart.ChartRenderer;
import org.codehaus.mojo.chronos.report.chart.ChartSource;
import org.jfree.chart.JFreeChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphGenerator {
    private final Log log;
    private List<ChartSource> summaryChartSources = new ArrayList<ChartSource>();
    private Map<String, List<ChartSource>> detailsChartSources = new LinkedHashMap<String, List<ChartSource>>();

    public GraphGenerator(List<ChartSource> summaryChartSources, Map<String, List<ChartSource>> detailsChartSources, Log log) {
        this.log = log;
        this.summaryChartSources = summaryChartSources;
        this.detailsChartSources = detailsChartSources;
    }

    public void generateGraphs(ChartRenderer renderer, ResourceBundle bundle, ReportConfig config) throws IOException {
        for (ChartSource chartSource : this.summaryChartSources) {
            if (!chartSource.isEnabled(config)) continue;
            JFreeChart chart = chartSource.getChart(bundle, config);
            String fileName = chartSource.getFileName(config);
            this.log.debug((CharSequence)("Rendering summary chart " + fileName));
            renderer.renderChart(fileName, chart);
        }
        if (config.isShowdetails()) {
            for (List list : this.detailsChartSources.values()) {
                for (ChartSource source : list) {
                    if (!source.isEnabled(config)) continue;
                    JFreeChart chart = source.getChart(bundle, config);
                    String fileName = source.getFileName(config);
                    this.log.debug((CharSequence)("Rendering detailed chart " + fileName));
                    renderer.renderChart(fileName, chart);
                }
            }
        }
    }

    public List<ChartSource> getSummaryChartSources() {
        return this.summaryChartSources;
    }

    public List<ChartSource> getDetailsChartSources(String testName) {
        return this.detailsChartSources.get(testName);
    }
}

