/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.codehaus.doxia.sink.Sink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReportSink {
    private ResourceBundle bundle;
    private Sink sink;

    public ReportSink(ResourceBundle bundle, Sink sink) {
        this.bundle = bundle;
        this.sink = sink;
    }

    void constructHeaderSection(String title, String description, String anchor) {
        if (title != null) {
            this.sink.sectionTitle1();
            this.sinkAnchor(anchor);
            this.sink.text(title);
            this.sink.sectionTitle1_();
        }
        if (description != null) {
            this.sink.rawText(description);
            this.sinkLineBreak();
        }
    }

    void metadataTable(String title, String anchor, Map metadata) {
        if (!metadata.isEmpty()) {
            this.title2(title, anchor);
            this.sink.table();
            for (Map.Entry entry : metadata.entrySet()) {
                this.sink.tableRow();
                this.sink.tableCell();
                this.sink.rawText((String)entry.getKey());
                this.sink.tableCell_();
                this.sink.tableCell();
                this.sink.rawText((String)entry.getValue());
                this.sink.tableCell_();
                this.sink.tableRow_();
            }
            this.sink.table_();
        }
    }

    void title2(String text, String anchor) {
        this.sink.sectionTitle2();
        this.sinkAnchor(anchor);
        this.sink.text(text);
        this.sink.sectionTitle2_();
    }

    void title3(String text, String anchor) {
        this.sink.sectionTitle3();
        this.sinkAnchor(anchor);
        this.sink.text(text);
        this.sink.sectionTitle3_();
    }

    void graphics(String name) {
        try {
            this.sink.figure();
            String encodedName = URLEncoder.encode(name, "UTF-8");
            this.sink.figureGraphics("images" + File.separatorChar + encodedName);
            this.sink.figure_();
            this.sinkLineBreak();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    void sinkLineBreak() {
        this.sink.lineBreak();
        this.sink.lineBreak();
    }

    void table(List<String> headerLabels, List<List<String>> dataLines) {
        this.sink.table();
        this.sink.tableRow();
        for (String headerLabel : headerLabels) {
            this.th(headerLabel);
        }
        this.sink.tableRow_();
        Iterator<List<String>> data = dataLines.iterator();
        while (data.hasNext()) {
            List<String> next;
            List<String> dataLine = next = data.next();
            this.sink.tableRow();
            for (String item : dataLine) {
                this.sinkCell(item);
            }
            this.sink.tableRow_();
        }
        this.sink.table_();
        this.sinkLineBreak();
    }

    void th(String key) {
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString(key));
        this.sink.tableHeaderCell_();
    }

    void sinkCell(String text) {
        this.sink.tableCell();
        this.sink.text(text);
        this.sink.tableCell_();
    }

    void sinkLink(String text, String link) {
        this.sink.rawText("[");
        this.sink.link("#" + link);
        this.sink.text(text);
        this.sink.link_();
        this.sink.rawText("]");
    }

    void sinkCellLink(String text, String link) {
        this.sink.tableCell();
        this.sink.link(link);
        this.sink.text(text);
        this.sink.link_();
        this.sink.tableCell_();
    }

    void sinkAnchor(String anchor) {
        this.sink.anchor(anchor);
        this.sink.anchor_();
    }
}

