/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.history;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.common.HistoricDataDirectory;
import org.codehaus.mojo.chronos.common.ProjectBaseDir;
import org.codehaus.mojo.chronos.common.TestDataDirectory;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.common.model.HistoricSample;
import org.xml.sax.SAXException;

public class SaveHistoryMojo
extends AbstractMojo {
    MavenProject project;
    File historydir;
    String dataid;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HistoricDataDirectory historicDataDirectory = new HistoricDataDirectory(this.historydir, this.dataid);
        ProjectBaseDir projectBaseDir = new ProjectBaseDir(this.project);
        TestDataDirectory testDataDirectory = projectBaseDir.getDataDirectory(this.dataid);
        try {
            GroupedResponsetimeSamples responseSamples = testDataDirectory.readResponsetimeSamples();
            if (responseSamples.getAllSamples().size() == 0) {
                throw new MojoExecutionException("Response time samples not found for " + this.dataid);
            }
            GCSamples gcSamples = testDataDirectory.readGCSamples();
            HistoricSample history = new HistoricSample(responseSamples, gcSamples);
            historicDataDirectory.writeHistorySample(history);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to find gcsamples with dataid=" + this.dataid, (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("unable to find gcsamples with dataid=" + this.dataid, (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("unable to find gcsamples with dataid=" + this.dataid, (Exception)e);
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException("unable to find gcsamples with dataid=" + this.dataid, (Exception)e);
        }
    }
}

