/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;

public class ReleasedVersionMojo
extends AbstractMojo {
    private MavenProject project;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private String propertyPrefix;

    public void execute() {
        block5: {
            Artifact artifact = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), "", "", "");
            try {
                Object releasedVersion = null;
                List versions = this.artifactMetadataSource.retrieveAvailableVersions(artifact, this.localRepository, this.remoteArtifactRepositories);
                for (ArtifactVersion version : versions) {
                    if (ArtifactUtils.isSnapshot((String)version.toString()) || releasedVersion != null && version.compareTo(releasedVersion) != 1) continue;
                    releasedVersion = version;
                }
                if (releasedVersion != null) {
                    int dashIndex = releasedVersion.toString().indexOf(45);
                    String releasedVersionValue = dashIndex >= 0 ? releasedVersion.toString().substring(0, dashIndex) : releasedVersion.toString();
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(this.propertyPrefix + ".version = " + releasedVersionValue));
                    }
                    Properties props = this.project.getProperties();
                    props.setProperty(this.propertyPrefix + ".version", releasedVersionValue);
                    props.setProperty(this.propertyPrefix + ".majorVersion", Integer.toString(releasedVersion.getMajorVersion()));
                    props.setProperty(this.propertyPrefix + ".minorVersion", Integer.toString(releasedVersion.getMinorVersion()));
                    props.setProperty(this.propertyPrefix + ".incrementalVersion", Integer.toString(releasedVersion.getIncrementalVersion()));
                }
            }
            catch (ArtifactMetadataRetrievalException e) {
                if (!this.getLog().isWarnEnabled()) break block5;
                this.getLog().warn((CharSequence)"Failed to retrieve artifacts metadata, cannot resolve the released version");
            }
        }
    }
}

