/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.mojo.appassembler.AbstractAppAssemblerMojo;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorService;
import org.codehaus.mojo.appassembler.daemon.script.Platform;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractScriptGeneratorMojo
extends AbstractAppAssemblerMojo {
    @Parameter
    protected String environmentSetupFileName;
    @Parameter
    protected File licenseHeaderFile;
    @Parameter(property="unixScriptTemplate")
    protected String unixScriptTemplate;
    @Parameter(defaultValue="false")
    protected boolean useWildcardClassPath;
    @Parameter(property="windowsScriptTemplate")
    protected String windowsScriptTemplate;
    @Parameter(defaultValue="${project.runtimeArtifacts}", readonly=true)
    protected List<Artifact> artifacts;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="true")
    protected boolean generateRepository;
    @Parameter(defaultValue="etc")
    protected String configurationDirectory;
    @Parameter(defaultValue="src/main/config")
    protected File configurationSourceDirectory;
    @Parameter(defaultValue="false")
    protected boolean filterConfigurationDirectory;
    @Parameter(defaultValue="false")
    protected boolean copyConfigurationDirectory;
    @Parameter
    protected File preAssembleDirectory;
    @Parameter(defaultValue="false")
    protected boolean filterPreAssembleDirectory;
    @Parameter
    protected String endorsedDir;
    @Parameter(defaultValue="${project.build.filters}", readonly=true)
    protected List<String> buildFilters;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter
    protected String escapeString;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="logsDirectory")
    protected String logsDirectory;
    @Parameter(property="tempDirectory")
    protected String tempDirectory;
    @Parameter
    protected Map<String, String> binFileExtensions;
    @Component
    protected DaemonGeneratorService daemonGeneratorService;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;

    protected void doCopyConfigurationDirectory(String targetDirectory) throws MojoFailureException {
        this.getLog().debug((CharSequence)"copying configuration directory.");
        Resource resource = new Resource();
        resource.setDirectory(this.configurationSourceDirectory.getAbsolutePath());
        resource.setFiltering(this.filterConfigurationDirectory);
        resource.setTargetPath(this.configurationDirectory);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, new File(targetDirectory), this.mavenProject, this.encoding, this.buildFilters, Collections.emptyList(), this.session);
        mavenResourcesExecution.setEscapeString(this.escapeString);
        mavenResourcesExecution.setIncludeEmptyDirs(true);
        mavenResourcesExecution.setUseDefaultFilterWrappers(true);
        try {
            this.getLog().debug((CharSequence)("Will try to copy configuration files from " + this.configurationSourceDirectory.getAbsolutePath() + " to " + targetDirectory + FileUtils.FS + this.configurationDirectory));
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException mfe) {
            throw new MojoFailureException("Failed to copy/filter the configuration files.");
        }
    }

    protected void doCopyPreAssembleDirectory(String targetDirectory) throws MojoFailureException {
        Resource resource = new Resource();
        resource.setDirectory(this.preAssembleDirectory.getAbsolutePath());
        resource.setFiltering(this.filterPreAssembleDirectory);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, new File(targetDirectory), this.mavenProject, this.encoding, this.buildFilters, Collections.emptyList(), this.session);
        mavenResourcesExecution.setEscapeString(this.escapeString);
        mavenResourcesExecution.setIncludeEmptyDirs(true);
        mavenResourcesExecution.setUseDefaultFilterWrappers(true);
        try {
            this.getLog().info((CharSequence)("Copy pre-assemble files from " + this.preAssembleDirectory.getAbsolutePath() + " to " + targetDirectory));
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException mfe) {
            throw new MojoFailureException("Failed to copy/filter the configuration files.");
        }
    }

    protected void doCreateExtraDirectories(File targetDirectory) throws MojoFailureException {
        boolean success;
        if (this.logsDirectory != null) {
            File logsDirectory = new File(targetDirectory, this.logsDirectory);
            if (logsDirectory.exists() && !logsDirectory.delete()) {
                throw new MojoFailureException("Failed to delete existing directory for log files.");
            }
            success = logsDirectory.mkdirs();
            if (!success) {
                throw new MojoFailureException("Failed to create directory for log files.");
            }
        }
        if (this.tempDirectory != null) {
            File tempDirectory = new File(targetDirectory, this.tempDirectory);
            if (tempDirectory.exists() && !tempDirectory.delete()) {
                throw new MojoFailureException("Failed to delete existing directory for temp files.");
            }
            success = tempDirectory.mkdirs();
            if (!success) {
                throw new MojoFailureException("Failed to create directory for temp files.");
            }
        }
    }

    protected void installDependencies(String outputDirectory, String repositoryName) throws MojoExecutionException, MojoFailureException {
        if (this.generateRepository) {
            ArtifactRepository artifactRepository = this.artifactRepositoryFactory.createDeploymentArtifactRepository("appassembler", "file://" + outputDirectory + "/" + repositoryName, this.getArtifactRepositoryLayout(), false);
            for (Artifact artifact : this.artifacts) {
                this.installArtifact(artifact, artifactRepository, this.useTimestampInSnapshotFileName);
            }
            this.installArtifact(this.projectArtifact, artifactRepository);
        }
    }

    protected void setBinFileExtensions() throws MojoFailureException {
        if (this.binFileExtensions != null) {
            for (String platformName : this.binFileExtensions.keySet()) {
                try {
                    Platform platform = Platform.getInstance(platformName);
                    platform.setBinFileExtension(this.binFileExtensions.get(platformName));
                }
                catch (DaemonGeneratorException e) {
                    this.getLog().warn((CharSequence)("Unable to set the bin file extension for " + platformName), (Throwable)e);
                }
            }
        }
    }
}

