/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.util;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.codehaus.plexus.util.StringUtils;

public final class ArtifactUtils {
    private ArtifactUtils() {
    }

    public static String pathBaseVersionOf(ArtifactRepositoryLayout artifactRepositoryLayout, Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuilder fileName = new StringBuilder();
        fileName.append(artifact.getArtifactId()).append("-").append(artifact.getBaseVersion());
        if (artifact.hasClassifier()) {
            fileName.append("-").append(artifact.getClassifier());
        }
        if (artifactHandler.getExtension() != null && artifactHandler.getExtension().length() > 0) {
            fileName.append(".").append(artifactHandler.getExtension());
        }
        String relativePath = artifactRepositoryLayout.pathOf(artifact);
        String[] tokens = StringUtils.split((String)relativePath, (String)"/");
        tokens[tokens.length - 1] = fileName.toString();
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            path.append(tokens[i]);
            if (i == tokens.length - 1) continue;
            path.append("/");
        }
        return path.toString();
    }
}

