/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.script;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.model.ClasspathElement;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;

public class Platform {
    public static final String UNIX_NAME = "unix";
    public static final String WINDOWS_NAME = "windows";
    private static final Map ALL_PLATFORMS = new HashMap();
    private static final String DEFAULT_UNIX_BIN_FILE_EXTENSION = "";
    private static final String DEFAULT_WINDOWS_BIN_FILE_EXTENSION = ".bat";
    private String binFileExtension;
    private String name;
    private boolean isWindows;

    private static Platform addPlatform(Platform platform) {
        ALL_PLATFORMS.put(platform.name, platform);
        return platform;
    }

    public static Platform getInstance(String platformName) throws DaemonGeneratorException {
        Platform platform = (Platform)ALL_PLATFORMS.get(platformName);
        if (platform == null) {
            throw new DaemonGeneratorException("Unknown platform name '" + platformName + "'");
        }
        return platform;
    }

    public static Set getAllPlatformNames() {
        return ALL_PLATFORMS.keySet();
    }

    public static Set getAllPlatforms() {
        return new HashSet(ALL_PLATFORMS.values());
    }

    public static Set getPlatformSet(List platformList) throws DaemonGeneratorException {
        return Platform.getPlatformSet(platformList, new HashSet(ALL_PLATFORMS.values()));
    }

    public static Set getPlatformSet(List platformList, Set allSet) throws DaemonGeneratorException {
        if (platformList == null) {
            return allSet;
        }
        if (platformList.size() == 1) {
            Object first = platformList.get(0);
            if ("all".equals(first)) {
                return allSet;
            }
            throw new DaemonGeneratorException("The special platform 'all' can only be used if it is the only element in the platform list.");
        }
        HashSet<Platform> platformSet = new HashSet<Platform>();
        Iterator it = platformList.iterator();
        while (it.hasNext()) {
            String platformName = (String)it.next();
            if (platformName.equals("all")) {
                throw new DaemonGeneratorException("The special platform 'all' can only be used if it is the only element in a platform list.");
            }
            platformSet.add(Platform.getInstance(platformName));
        }
        return platformSet;
    }

    private Platform(String name, boolean isWindows, String binFileExtension) {
        this.name = name;
        this.isWindows = isWindows;
        this.binFileExtension = binFileExtension;
    }

    public String getInterpolationToken() {
        return this.isWindows ? "#" : "@";
    }

    public String getBinFileExtension() {
        return this.binFileExtension;
    }

    public String getBasedir() {
        return this.isWindows ? "\"%BASEDIR%\"" : "\"$BASEDIR\"";
    }

    public String getRepo() {
        return this.isWindows ? "\"%REPO%\"" : "\"$REPO\"";
    }

    public String getSeparator() {
        return this.isWindows ? "\\" : "/";
    }

    public String getPathSeparator() {
        return this.isWindows ? ";" : ":";
    }

    public String getCommentPrefix() {
        return this.isWindows ? "@REM " : "# ";
    }

    public String getNewLine() {
        return this.isWindows ? "\r\n" : "\n";
    }

    public String getClassPath(Daemon daemon) throws DaemonGeneratorException {
        List classpath = daemon.getAllClasspathElements();
        StringBuffer classpathBuffer = new StringBuffer();
        Iterator it = classpath.iterator();
        while (it.hasNext()) {
            Object object;
            if (classpathBuffer.length() > 0) {
                classpathBuffer.append(this.getPathSeparator());
            }
            if ((object = it.next()) instanceof Directory) {
                Directory directory = (Directory)object;
                if (directory.getRelativePath().charAt(0) != '/') {
                    classpathBuffer.append(this.getBasedir()).append(this.getSeparator());
                }
            } else if (object instanceof Dependency) {
                classpathBuffer.append(this.getRepo()).append(this.getSeparator());
            } else {
                throw new DaemonGeneratorException("Unknown classpath element type: " + object.getClass().getName());
            }
            classpathBuffer.append(StringUtils.replace((String)((ClasspathElement)object).getRelativePath(), (String)"/", (String)this.getSeparator()));
        }
        return classpathBuffer.toString();
    }

    private String interpolateBaseDirAndRepo(String content) {
        StringReader sr = new StringReader(content);
        StringWriter result = new StringWriter();
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("BASEDIR", StringUtils.quoteAndEscape((String)this.getBasedir(), (char)'\"'));
        context.put("REPO", StringUtils.quoteAndEscape((String)this.getRepo(), (char)'\"'));
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)sr, context, "@", "@");
        try {
            IOUtil.copy((Reader)interpolationFilterReader, (Writer)result);
        }
        catch (IOException e) {
            // empty catch block
        }
        return result.toString();
    }

    private List convertArguments(List strings) {
        if (strings == null) {
            return strings;
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = strings.iterator();
        while (iterator.hasNext()) {
            String argument = (String)iterator.next();
            result.add(this.interpolateBaseDirAndRepo(argument));
        }
        return result;
    }

    public String getExtraJvmArguments(JvmSettings jvmSettings) throws IOException {
        if (jvmSettings == null) {
            return DEFAULT_UNIX_BIN_FILE_EXTENSION;
        }
        String vmArgs = DEFAULT_UNIX_BIN_FILE_EXTENSION;
        vmArgs = this.addJvmSetting("-Xms", jvmSettings.getInitialMemorySize(), vmArgs);
        vmArgs = this.addJvmSetting("-Xmx", jvmSettings.getMaxMemorySize(), vmArgs);
        vmArgs = this.addJvmSetting("-Xss", jvmSettings.getMaxStackSize(), vmArgs);
        vmArgs = vmArgs + this.arrayToString(this.convertArguments(jvmSettings.getExtraArguments()), DEFAULT_UNIX_BIN_FILE_EXTENSION);
        vmArgs = vmArgs + this.arrayToString(jvmSettings.getSystemProperties(), "-D");
        return vmArgs.trim();
    }

    private String arrayToString(List strings, String separator) {
        String string = DEFAULT_UNIX_BIN_FILE_EXTENSION;
        if (strings != null) {
            Iterator it = strings.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.indexOf(32) == -1) {
                    string = string + " " + separator + s;
                    continue;
                }
                string = string + " \"" + separator + s + "\"";
            }
        }
        return string;
    }

    public String getAppArguments(Daemon descriptor) {
        List commandLineArguments = this.convertArguments(descriptor.getCommandLineArguments());
        if (commandLineArguments == null || commandLineArguments.size() == 0) {
            return null;
        }
        if (commandLineArguments.size() == 1) {
            return (String)commandLineArguments.get(0);
        }
        Iterator it = commandLineArguments.iterator();
        String appArguments = (String)it.next();
        while (it.hasNext()) {
            appArguments = appArguments + " " + it.next();
        }
        return appArguments;
    }

    private String addJvmSetting(String argType, String extraJvmArgument, String vmArgs) {
        if (StringUtils.isEmpty((String)extraJvmArgument)) {
            return vmArgs;
        }
        return vmArgs + " " + argType + extraJvmArgument;
    }

    public String getEnvSetup(Daemon daemon) {
        String envSetup = DEFAULT_UNIX_BIN_FILE_EXTENSION;
        String envSetupFileName = daemon.getEnvironmentSetupFileName();
        if (envSetupFileName != null) {
            if (this.isWindows) {
                String envScriptPath = "\"%BASEDIR%\\bin\\" + envSetupFileName + ".bat\"";
                envSetup = "if exist " + envScriptPath + " call " + envScriptPath;
            } else {
                String envScriptPath = "\"$BASEDIR\"/bin/" + envSetupFileName;
                envSetup = "[ -f " + envScriptPath + " ] && . " + envScriptPath;
            }
        }
        return envSetup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Platform platform = (Platform)o;
        return this.name.equals(platform.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public boolean isShowConsoleWindow(Daemon daemon) {
        return daemon.isShowConsoleWindow() && this.isWindows;
    }

    public void setBinFileExtension(String binFileExtension) {
        this.binFileExtension = binFileExtension == null ? DEFAULT_UNIX_BIN_FILE_EXTENSION : binFileExtension;
    }

    static {
        Platform.addPlatform(new Platform(UNIX_NAME, false, DEFAULT_UNIX_BIN_FILE_EXTENSION));
        Platform.addPlatform(new Platform(WINDOWS_NAME, true, DEFAULT_WINDOWS_BIN_FILE_EXTENSION));
    }
}

