/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.booter;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.script.AbstactScriptDaemonGenerator;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.JvmSettings;

public abstract class AbstractBooterDaemonGenerator
extends AbstactScriptDaemonGenerator {
    private DaemonGenerator genericDaemonGenerator;

    protected AbstractBooterDaemonGenerator(String platformName) {
        super(platformName);
    }

    public void generate(DaemonGenerationRequest request) throws DaemonGeneratorException {
        Daemon daemon = request.getDaemon();
        JvmSettings jvmSettings = daemon.getJvmSettings();
        File outputDirectory = request.getOutputDirectory();
        request.setOutputDirectory(new File(outputDirectory, "etc"));
        daemon.setJvmSettings(null);
        this.genericDaemonGenerator.generate(request);
        daemon.setJvmSettings(jvmSettings);
        Daemon booterDaemon = new Daemon();
        booterDaemon.setId(daemon.getId());
        booterDaemon.setEnvironmentSetupFileName(daemon.getEnvironmentSetupFileName());
        booterDaemon.setModelEncoding(daemon.getModelEncoding());
        booterDaemon.setMainClass("org.codehaus.mojo.appassembler.booter.AppassemblerBooter");
        booterDaemon.setShowConsoleWindow(daemon.isShowConsoleWindow());
        booterDaemon.setJvmSettings(jvmSettings);
        MavenProject project = request.getMavenProject();
        Classpath classpath = new Classpath();
        booterDaemon.setClasspath(classpath);
        classpath.addDirectory(AbstractBooterDaemonGenerator.createDirectory("etc"));
        classpath.addDependency(AbstractBooterDaemonGenerator.createDependency(project, "org.codehaus.mojo.appassembler:appassembler-booter", request.getRepositoryLayout()));
        classpath.addDependency(AbstractBooterDaemonGenerator.createDependency(project, "org.codehaus.mojo.appassembler:appassembler-model", request.getRepositoryLayout()));
        classpath.addDependency(AbstractBooterDaemonGenerator.createDependency(project, "org.codehaus.plexus:plexus-utils", request.getRepositoryLayout()));
        classpath.addDependency(AbstractBooterDaemonGenerator.createDependency(project, "stax:stax-api", request.getRepositoryLayout()));
        classpath.addDependency(AbstractBooterDaemonGenerator.createDependency(project, "stax:stax", request.getRepositoryLayout()));
        this.scriptGenerator.createBinScript(this.getPlatformName(), booterDaemon, outputDirectory, "bin");
    }

    private static Dependency createDependency(MavenProject project, String id, ArtifactRepositoryLayout artifactRepositoryLayout) throws DaemonGeneratorException {
        Artifact artifact = (Artifact)project.getArtifactMap().get(id);
        if (artifact == null) {
            throw new DaemonGeneratorException("The project has to have a dependency on '" + id + "'.");
        }
        Dependency dependency = new Dependency();
        dependency.setRelativePath(artifactRepositoryLayout.pathOf(artifact));
        return dependency;
    }

    private static Directory createDirectory(String relativePath) {
        Directory directory = new Directory();
        directory.setRelativePath(relativePath);
        return directory;
    }
}

