/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.stax;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.stax.DummyIdModelField;
import org.codehaus.modello.plugins.xml.AbstractXmlJavaGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;

public abstract class AbstractStaxGenerator
extends AbstractXmlJavaGenerator {
    private Set<ModelClass> parts;

    protected void initialize(Model model, Map<String, Object> parameters) throws ModelloException {
        super.initialize(model, parameters);
        this.parts = null;
    }

    protected ModelField getReferenceIdentifierField(ModelAssociation association) throws ModelloException {
        XmlAssociationMetadata xmlAssocMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
        DummyIdModelField referenceIdentifierField = null;
        if (xmlAssocMetadata.isReference()) {
            String associationName = association.getName();
            ModelClass modelClass = association.getModelClass();
            if (!this.isClassInModel(association.getTo(), modelClass.getModel())) {
                throw new ModelloException("Can't use xml.reference on the '" + associationName + "' association of '" + modelClass.getName() + "' because the target class '" + association.getTo() + "' is not in the model");
            }
            List identifierFields = association.getToClass().getIdentifierFields(this.getGeneratedVersion());
            if (identifierFields.size() == 1) {
                referenceIdentifierField = (ModelField)identifierFields.get(0);
            } else {
                referenceIdentifierField = new DummyIdModelField();
                referenceIdentifierField.setName("modello.refid");
            }
        }
        return referenceIdentifierField;
    }

    protected boolean isAssociationPartToClass(ModelClass modelClass) {
        if (this.parts == null) {
            this.parts = new HashSet<ModelClass>();
            for (ModelClass clazz : modelClass.getModel().getClasses(this.getGeneratedVersion())) {
                for (ModelField modelField : clazz.getFields(this.getGeneratedVersion())) {
                    ModelAssociation assoc;
                    XmlAssociationMetadata xmlAssocMetadata;
                    if (!(modelField instanceof ModelAssociation) || !(xmlAssocMetadata = (XmlAssociationMetadata)(assoc = (ModelAssociation)modelField).getAssociationMetadata(XmlAssociationMetadata.ID)).isReference()) continue;
                    this.parts.add(assoc.getToClass());
                }
            }
        }
        return this.parts.contains(modelClass);
    }
}

