/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.modello.plugin.java.javasource.JAnnotations;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JDocComment;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMember;
import org.codehaus.modello.plugin.java.javasource.JMethodSignature;
import org.codehaus.modello.plugin.java.javasource.JModifiers;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;

public final class JInterface
extends JStructure {
    private Map<String, JField> fields = null;
    private List<JMethodSignature> methods = null;
    private List<String> sourceCodeEntries = new ArrayList<String>();

    public JInterface(String name) throws IllegalArgumentException {
        super(name);
        this.methods = new ArrayList<JMethodSignature>();
        this.getJDocComment().appendComment("Interface " + this.getLocalName() + ".");
    }

    @Override
    public void addField(JField jField) throws IllegalArgumentException {
        if (jField == null) {
            throw new IllegalArgumentException("argument 'jField' cannot be null");
        }
        String name = jField.getName();
        if (this.fields != null && this.fields.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        JModifiers modifiers = jField.getModifiers();
        if (!modifiers.isStatic()) {
            throw new IllegalArgumentException("Fields added to a JInterface must be static.");
        }
        if (modifiers.isPrivate()) {
            throw new IllegalArgumentException("Fields added to a JInterface must not be private.");
        }
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, JField>(3);
        }
        this.fields.put(name, jField);
    }

    @Override
    public void addMember(JMember jMember) throws IllegalArgumentException {
        if (jMember == null) {
            throw new IllegalArgumentException("argument 'jMember' may not be null.");
        }
        if (!(jMember instanceof JField)) {
            throw new IllegalArgumentException("invalid member for JInterface: " + jMember.toString());
        }
        this.addField((JField)jMember);
    }

    public void addMethod(JMethodSignature jMethodSig) throws IllegalArgumentException {
        JClass[] exceptions;
        JType jType;
        if (jMethodSig == null) {
            String err = "The JMethodSignature cannot be null.";
            throw new IllegalArgumentException(err);
        }
        boolean added = false;
        JModifiers modifiers = jMethodSig.getModifiers();
        for (int i = 0; i < this.methods.size(); ++i) {
            JMethodSignature tmp = this.methods.get(i);
            if (tmp.getModifiers().isProtected() && !modifiers.isProtected()) {
                this.methods.add(i, jMethodSig);
                added = true;
                break;
            }
            if (jMethodSig.getName().compareTo(tmp.getName()) >= 0) continue;
            this.methods.add(i, jMethodSig);
            added = true;
            break;
        }
        if (!added) {
            this.methods.add(jMethodSig);
        }
        if ((jType = jMethodSig.getReturnType()) != null) {
            while (jType.isArray()) {
                jType = jType.getComponentType();
            }
            if (!jType.isPrimitive()) {
                this.addImport(jType.getName());
            }
        }
        for (JClass exception : exceptions = jMethodSig.getExceptions()) {
            this.addImport(exception.getName());
        }
    }

    @Override
    public JField getField(String name) {
        if (this.fields == null) {
            return null;
        }
        return this.fields.get(name);
    }

    @Override
    public JField[] getFields() {
        if (this.fields == null) {
            return new JField[0];
        }
        return this.fields.values().toArray(new JField[0]);
    }

    public JMethodSignature[] getMethods() {
        return this.methods.toArray(new JMethodSignature[0]);
    }

    public JMethodSignature getMethod(String name, int startIndex) {
        for (JMethodSignature jMethod : this.methods) {
            if (!jMethod.getName().equals(name)) continue;
            return jMethod;
        }
        return null;
    }

    public JMethodSignature getMethod(int index) {
        return this.methods.get(index);
    }

    @Override
    public void print(JSourceWriter jsw) {
        this.print(jsw, false);
    }

    public void print(JSourceWriter jsw, boolean classOnly) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuilder buffer = new StringBuilder();
        if (!classOnly) {
            this.printHeader(jsw);
            this.printPackageDeclaration(jsw);
            this.printImportDeclarations(jsw);
        }
        this.getJDocComment().print(jsw);
        JAnnotations annotations = this.getAnnotations();
        if (annotations != null) {
            annotations.print(jsw);
        }
        buffer.setLength(0);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        if (modifiers.isAbstract()) {
            buffer.append("abstract ");
        }
        buffer.append("interface ");
        buffer.append(this.getLocalName());
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
        jsw.indent();
        if (this.getInterfaceCount() > 0) {
            Enumeration<String> e = this.getInterfaces();
            buffer.append("extends ");
            while (e.hasMoreElements()) {
                buffer.append(e.nextElement());
                if (!e.hasMoreElements()) continue;
                buffer.append(", ");
            }
            jsw.writeln(buffer.toString());
            buffer.setLength(0);
        }
        jsw.unindent();
        jsw.writeln('{');
        jsw.indent();
        if (this.fields != null) {
            if (this.fields.size() > 0) {
                jsw.writeln();
                jsw.writeln("  //--------------------------/");
                jsw.writeln(" //- Class/Member Variables -/");
                jsw.writeln("//--------------------------/");
                jsw.writeln();
            }
            for (JField jField : this.fields.values()) {
                JDocComment comment = jField.getComment();
                if (comment != null) {
                    comment.print(jsw);
                }
                jsw.write(jField.getModifiers().toString());
                jsw.write(32);
                JType type = jField.getType();
                String typeName = type.toString();
                if (typeName.equals(this.toString())) {
                    typeName = type.getLocalName();
                }
                jsw.write(typeName);
                jsw.write(32);
                jsw.write(jField.getName());
                String init = jField.getInitString();
                if (init != null) {
                    jsw.write(" = ");
                    jsw.write(init);
                }
                jsw.writeln(';');
                jsw.writeln();
            }
        }
        if (this.methods.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------/");
            jsw.writeln(" //- Methods -/");
            jsw.writeln("//-----------/");
            jsw.writeln();
        }
        for (JMethodSignature signature : this.methods) {
            signature.print(jsw);
            jsw.writeln(';');
        }
        for (String sourceCodeEntry : this.sourceCodeEntries) {
            jsw.writeln(sourceCodeEntry);
        }
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
        jsw.close();
    }

    public void addSourceCode(String sourceCode) {
        this.sourceCodeEntries.add(sourceCode);
    }
}

