/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.commons.nullanalysis.Nullable;

public class MultiReader
extends Reader {
    private static final Reader EMPTY_READER = new StringReader("");
    private final List<Reader> delegates;
    private final Iterator<Reader> delegateIterator;
    private Reader currentDelegate = EMPTY_READER;

    public MultiReader(List<Reader> delegates) {
        this.delegates = delegates;
        this.delegateIterator = delegates.iterator();
    }

    public MultiReader(Reader[] delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public void close() throws IOException {
        for (Reader delegate : this.delegates) {
            delegate.close();
        }
    }

    @Override
    public int read() throws IOException {
        int result;
        while ((result = this.currentDelegate.read()) == -1) {
            if (!this.delegateIterator.hasNext()) {
                return -1;
            }
            this.currentDelegate = this.delegateIterator.next();
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result;
        while ((result = this.currentDelegate.skip(n)) == -1L) {
            if (!this.delegateIterator.hasNext()) {
                return 0L;
            }
            this.currentDelegate = this.delegateIterator.next();
        }
        return result;
    }

    @Override
    public int read(@Nullable char[] cbuf, int off, int len) throws IOException {
        int result;
        while ((long)(result = this.currentDelegate.read(cbuf, off, len)) == -1L) {
            if (!this.delegateIterator.hasNext()) {
                return -1;
            }
            this.currentDelegate = this.delegateIterator.next();
        }
        return result;
    }
}

