/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.jdk.SimpleCompiler;
import org.codehaus.commons.io.MultiReader;

public class ClassBodyEvaluator
extends SimpleCompiler
implements IClassBodyEvaluator {
    private String[] optionalDefaultImports = null;
    private String className = "SC";
    private Class<?> optionalExtendedType = null;
    private Class<?>[] implementedTypes = new Class[0];
    private Class<?> result = null;
    private static final Pattern IMPORT_STATEMENT_PATTERN = Pattern.compile("\\bimport\\s+((?:static\\s+)?[\\p{javaLowerCase}\\p{javaUpperCase}_\\$][\\p{javaLowerCase}\\p{javaUpperCase}\\d_\\$]*(?:\\.[\\p{javaLowerCase}\\p{javaUpperCase}_\\$][\\p{javaLowerCase}\\p{javaUpperCase}\\d_\\$]*)*(?:\\.\\*)?);");

    public void setClassName(String className) {
        this.assertNotCooked();
        this.className = className;
    }

    public void setDefaultImports(String[] optionalDefaultImports) {
        this.assertNotCooked();
        this.optionalDefaultImports = optionalDefaultImports;
    }

    public void setExtendedClass(Class optionalExtendedType) {
        this.assertNotCooked();
        this.optionalExtendedType = optionalExtendedType;
    }

    public void setExtendedType(Class optionalExtendedClass) {
        this.setExtendedClass(optionalExtendedClass);
    }

    public void setImplementedInterfaces(Class[] implementedTypes) {
        this.assertNotCooked();
        this.implementedTypes = implementedTypes;
    }

    public void setImplementedTypes(Class[] implementedInterfaces) {
        this.setImplementedInterfaces(implementedInterfaces);
    }

    @Override
    public void cook(String optionalFileName, Reader r) throws CompileException, IOException {
        if (!r.markSupported()) {
            r = new BufferedReader(r);
        }
        this.cook(optionalFileName, ClassBodyEvaluator.parseImportDeclarations(r), r);
    }

    protected void cook(String optionalFileName, String[] imports, Reader r) throws CompileException, IOException {
        String simpleClassName;
        String packageName;
        StringWriter sw1 = new StringWriter();
        PrintWriter pw = new PrintWriter(sw1);
        int idx = this.className.lastIndexOf(46);
        if (idx == -1) {
            packageName = "";
            simpleClassName = this.className;
        } else {
            packageName = this.className.substring(0, idx);
            simpleClassName = this.className.substring(idx + 1);
        }
        if (!packageName.isEmpty()) {
            pw.print("package ");
            pw.print(packageName);
            pw.println(";");
        }
        if (this.optionalDefaultImports != null) {
            for (String defaultImport : this.optionalDefaultImports) {
                pw.print("import ");
                pw.print(defaultImport);
                pw.println(";");
            }
        }
        if (!r.markSupported()) {
            r = new BufferedReader(r);
        }
        for (String imporT : imports) {
            pw.print("import ");
            pw.print(imporT);
            pw.println(";");
        }
        pw.print("public class ");
        pw.print(simpleClassName);
        if (this.optionalExtendedType != null) {
            pw.print(" extends ");
            pw.print(this.optionalExtendedType.getCanonicalName());
        }
        if (this.implementedTypes.length > 0) {
            pw.print(" implements ");
            pw.print(this.implementedTypes[0].getName());
            for (int i = 1; i < this.implementedTypes.length; ++i) {
                pw.print(", ");
                pw.print(this.implementedTypes[i].getName());
            }
        }
        pw.println(" {");
        pw.close();
        StringWriter sw2 = new StringWriter();
        PrintWriter pw2 = new PrintWriter(sw2);
        pw2.println("}");
        pw2.close();
        r = new MultiReader(new Reader[]{new StringReader(sw1.toString()), r, new StringReader(sw2.toString())});
        super.cook(optionalFileName, r);
        try {
            this.result = this.getClassLoader().loadClass(this.className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
    }

    public Class<?> getClazz() {
        return this.result;
    }

    protected static String[] parseImportDeclarations(Reader r) throws IOException {
        CharBuffer cb = CharBuffer.allocate(10000);
        r.mark(cb.limit());
        r.read(cb);
        cb.rewind();
        ArrayList<String> imports = new ArrayList<String>();
        int afterLastImport = 0;
        Matcher matcher = IMPORT_STATEMENT_PATTERN.matcher(cb);
        while (matcher.find()) {
            imports.add(matcher.group(1));
            afterLastImport = matcher.end();
        }
        r.reset();
        r.skip(afterLastImport);
        return imports.toArray(new String[imports.size()]);
    }

    public Object createInstance(Reader reader) throws CompileException, IOException {
        this.cook(reader);
        try {
            return this.getClazz().newInstance();
        }
        catch (InstantiationException ie) {
            CompileException ce = new CompileException("Class is abstract, an interface, an array class, a primitive type, or void; or has no zero-parameter constructor", null);
            ce.initCause((Throwable)ie);
            throw ce;
        }
        catch (IllegalAccessException iae) {
            CompileException ce = new CompileException("The class or its zero-parameter constructor is not accessible", null);
            ce.initCause((Throwable)iae);
            throw ce;
        }
    }
}

