/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBuilder {
    final SerializationConfig _config;
    final BasicBeanDescription _beanDesc;
    final JsonSerialize.Inclusion _outputProps;
    final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;

    public PropertyBuilder(SerializationConfig config, BasicBeanDescription beanDesc) {
        this._config = config;
        this._beanDesc = beanDesc;
        this._outputProps = beanDesc.findSerializationInclusion(config.getSerializationInclusion());
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public BeanPropertyWriter buildProperty(String name, JsonSerializer<Object> ser, AnnotatedMethod am) {
        Class<?> serializationType = this.findSerializationType(am);
        JsonSerialize.Inclusion methodProps = this._annotationIntrospector.findSerializationInclusion(am, this._outputProps);
        Method m = am.getAnnotated();
        switch (methodProps) {
            case NON_DEFAULT: {
                Object defValue = this.getDefaultValue(name, am, this.getDefaultBean());
                if (defValue != null) {
                    return new BeanPropertyWriter.NonDefaultMethod(name, ser, serializationType, m, defValue);
                }
            }
            case NON_NULL: {
                return new BeanPropertyWriter.NonNullMethod(name, ser, serializationType, m);
            }
        }
        return new BeanPropertyWriter.StdMethod(name, ser, serializationType, m);
    }

    public BeanPropertyWriter buildProperty(String name, JsonSerializer<Object> ser, AnnotatedField af) {
        Class<?> serializationType = this.findSerializationType(af);
        JsonSerialize.Inclusion methodProps = this._annotationIntrospector.findSerializationInclusion(af, this._outputProps);
        Field f = af.getAnnotated();
        switch (methodProps) {
            case NON_DEFAULT: {
                Object defValue = this.getDefaultValue(name, af, this.getDefaultBean());
                if (defValue != null) {
                    return new BeanPropertyWriter.NonDefaultField(name, ser, serializationType, f, defValue);
                }
            }
            case NON_NULL: {
                return new BeanPropertyWriter.NonNullField(name, ser, serializationType, f);
            }
        }
        return new BeanPropertyWriter.StdField(name, ser, serializationType, f);
    }

    protected Class<?> findSerializationType(Annotated a) {
        Class<?> type;
        Class<?> serializationType = this._annotationIntrospector.findSerializationType(a);
        if (serializationType != null && !serializationType.isAssignableFrom(type = a.getType())) {
            throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + a.getName() + "': class " + serializationType.getName() + " not a super-type of (declared) class " + type.getName());
        }
        return serializationType;
    }

    protected Object getDefaultBean() {
        if (this._defaultBean == null) {
            this._defaultBean = this._beanDesc.instantiateBean(this._config.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS));
            if (this._defaultBean == null) {
                AnnotatedElement cls = this._beanDesc.getClassInfo().getAnnotated();
                throw new IllegalArgumentException("Class " + ((Class)cls).getName() + " has no default constructor; can not instantiate default bean value to support 'properties=JsonSerialize.Inclusion.NON_DEFAULT' annotation");
            }
        }
        return this._defaultBean;
    }

    protected Object _throwWrapped(Exception e, String propName, Object defaultBean) {
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new IllegalArgumentException("Failed to get property '" + propName + "' of default " + defaultBean.getClass().getName() + " instance");
    }

    protected Object getDefaultValue(String name, AnnotatedMethod am, Object defaultBean) {
        Method m = am.getAnnotated();
        try {
            return m.invoke(defaultBean, new Object[0]);
        }
        catch (Exception e) {
            return this._throwWrapped(e, name, defaultBean);
        }
    }

    protected Object getDefaultValue(String name, AnnotatedField af, Object defaultBean) {
        Field f = af.getAnnotated();
        try {
            return f.get(defaultBean);
        }
        catch (Exception e) {
            return this._throwWrapped(e, name, defaultBean);
        }
    }
}

