/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.deser.StdDeserializationContext;
import org.codehaus.jackson.map.deser.StdDeserializerProvider;
import org.codehaus.jackson.map.ser.BeanSerializerFactory;
import org.codehaus.jackson.map.ser.StdSerializerProvider;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMapper
extends ObjectCodec {
    static final JavaType JSON_NODE_TYPE = TypeFactory.fromClass(JsonNode.class);
    protected final JsonFactory _jsonFactory;
    protected SerializerProvider _serializerProvider;
    protected SerializerFactory _serializerFactory;
    protected DeserializerProvider _deserializerProvider;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jf) {
        this(jf, null, null);
    }

    public ObjectMapper(SerializerFactory sf) {
        this(null, null, null);
        this.setSerializerFactory(sf);
    }

    public ObjectMapper(JsonFactory jf, SerializerProvider sp, DeserializerProvider dp) {
        this._jsonFactory = jf == null ? new MappingJsonFactory() : jf;
        this._serializerProvider = sp == null ? new StdSerializerProvider() : sp;
        this._deserializerProvider = dp == null ? new StdDeserializerProvider() : dp;
        this._serializerFactory = BeanSerializerFactory.instance;
    }

    public void setSerializerFactory(SerializerFactory f) {
        this._serializerFactory = f;
    }

    public void setSerializerProvider(SerializerProvider p) {
        this._serializerProvider = p;
    }

    public void setDeserializerProvider(DeserializerProvider p) {
        this._deserializerProvider = p;
    }

    public JsonFactory getJsonFactory() {
        return this._jsonFactory;
    }

    public <T> T readValue(JsonParser jp, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(jp, TypeFactory.fromClass(valueType));
    }

    public <T> T readValue(JsonParser jp, TypeReference<?> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(jp, TypeFactory.fromTypeReference(valueTypeRef));
    }

    public <T> T readValue(JsonParser jp, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(jp, valueType);
    }

    public JsonNode readTree(JsonParser jp) throws IOException, JsonProcessingException {
        JsonNode n = (JsonNode)this._readValue(jp, JSON_NODE_TYPE);
        return n == null ? NullNode.instance : n;
    }

    public void writeValue(JsonGenerator jgen, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        this._serializerProvider.serializeValue(jgen, value, this._serializerFactory);
        jgen.flush();
    }

    public void writeTree(JsonGenerator jgen, JsonNode rootNode) throws IOException, JsonProcessingException {
        this._serializerProvider.serializeValue(jgen, rootNode, this._serializerFactory);
        jgen.flush();
    }

    public boolean canSerialize(Class<?> type) {
        return this._serializerProvider.hasSerializerFor(type, this._serializerFactory);
    }

    public boolean canDeserialize(JavaType type) {
        return this._deserializerProvider.hasValueDeserializerFor(type);
    }

    public <T> T readValue(File src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), TypeFactory.fromClass(valueType));
    }

    public <T> T readValue(File src, TypeReference valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), TypeFactory.fromTypeReference(valueTypeRef));
    }

    public <T> T readValue(File src, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), valueType);
    }

    public <T> T readValue(URL src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), TypeFactory.fromClass(valueType));
    }

    public <T> T readValue(URL src, TypeReference valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), TypeFactory.fromTypeReference(valueTypeRef));
    }

    public <T> T readValue(URL src, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), valueType);
    }

    public <T> T readValue(String content, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(content), TypeFactory.fromClass(valueType));
    }

    public <T> T readValue(String content, TypeReference valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(content), TypeFactory.fromTypeReference(valueTypeRef));
    }

    public <T> T readValue(String content, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(content), valueType);
    }

    public <T> T readValue(Reader src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), TypeFactory.fromClass(valueType));
    }

    public <T> T readValue(Reader src, TypeReference valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), TypeFactory.fromTypeReference(valueTypeRef));
    }

    public <T> T readValue(Reader src, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), valueType);
    }

    public <T> T readValue(InputStream src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), TypeFactory.fromClass(valueType));
    }

    public <T> T readValue(InputStream src, TypeReference valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), TypeFactory.fromTypeReference(valueTypeRef));
    }

    public <T> T readValue(InputStream src, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), valueType);
    }

    public <T> T readValue(byte[] src, int offset, int len, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src, offset, len), TypeFactory.fromClass(valueType));
    }

    public <T> T readValue(byte[] src, int offset, int len, TypeReference valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src, offset, len), TypeFactory.fromTypeReference(valueTypeRef));
    }

    public <T> T readValue(byte[] src, int offset, int len, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src, offset, len), valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(File resultFile, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        JsonGenerator jgen = this._jsonFactory.createJsonGenerator(resultFile, JsonEncoding.UTF8);
        boolean closed = false;
        try {
            this.writeValue(jgen, value);
            closed = true;
            jgen.close();
        }
        finally {
            if (!closed) {
                try {
                    jgen.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(OutputStream out, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        JsonGenerator jgen = this._jsonFactory.createJsonGenerator(out, JsonEncoding.UTF8);
        boolean closed = false;
        try {
            this.writeValue(jgen, value);
            closed = true;
            jgen.close();
        }
        finally {
            if (!closed) {
                jgen.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(Writer w, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        JsonGenerator jgen = this._jsonFactory.createJsonGenerator(w);
        boolean closed = false;
        try {
            this.writeValue(jgen, value);
            closed = true;
            jgen.close();
        }
        finally {
            if (!closed) {
                jgen.close();
            }
        }
    }

    protected Object _readValue(JsonParser jp, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        Object result;
        if (!this._initForReading(jp)) {
            result = null;
        } else {
            DeserializationContext ctxt = this._createDeserializationContext(jp);
            result = this._findRootDeserializer(valueType).deserialize(jp, ctxt);
        }
        jp.nextToken();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _readMapAndClose(JsonParser jp, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        try {
            Object result;
            if (!this._initForReading(jp)) {
                result = null;
            } else {
                DeserializationContext ctxt = this._createDeserializationContext(jp);
                result = this._findRootDeserializer(valueType).deserialize(jp, ctxt);
                jp.nextToken();
            }
            Object object = result;
            return object;
        }
        finally {
            try {
                jp.close();
            }
            catch (IOException ioe) {}
        }
    }

    protected JsonDeserializer<Object> _findRootDeserializer(JavaType valueType) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._rootDeserializers.get(valueType);
        if (deser != null) {
            return deser;
        }
        deser = this._deserializerProvider.findValueDeserializer(valueType, null, null);
        if (deser == null) {
            throw new JsonMappingException("Can not find a deserializer for type " + valueType);
        }
        this._rootDeserializers.put(valueType, deser);
        return deser;
    }

    protected DeserializationContext _createDeserializationContext(JsonParser jp) {
        return new StdDeserializationContext(jp);
    }

    protected boolean _initForReading(JsonParser jp) throws IOException, JsonParseException, JsonMappingException {
        JsonToken t = jp.getCurrentToken();
        if (t == null && (t = jp.nextToken()) == null) {
            throw JsonMappingException.from(jp, "No content available via given JsonParser");
        }
        return t != JsonToken.VALUE_NULL;
    }
}

