/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.ser.BasicSerializerFactory;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.codehaus.jackson.map.ser.JsonValueSerializer;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializerFactory
extends BasicSerializerFactory {
    public static final BeanSerializerFactory instance = new BeanSerializerFactory();

    protected BeanSerializerFactory() {
    }

    @Override
    public <T> JsonSerializer<T> createSerializer(Class<T> type, SerializationConfig config) {
        JsonSerializer<Object> ser = super.findSerializerByLookup(type);
        if (ser == null && (ser = super.findSerializerByPrimaryType(type, config)) == null && (ser = this.findBeanSerializer(type, config)) == null) {
            ser = super.findSerializerByAddonType(type);
        }
        return ser;
    }

    public JsonSerializer<Object> findBeanSerializer(Class<?> type, SerializationConfig config) {
        if (!this.isPotentialBeanType(type)) {
            return null;
        }
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(type);
        JsonSerializer<Object> ser = this.findSerializerFromAnnotation(beanDesc.getClassInfo());
        if (ser != null) {
            return ser;
        }
        AnnotatedMethod valueMethod = beanDesc.findJsonValue();
        if (valueMethod != null) {
            ser = this.findSerializerFromAnnotation(valueMethod);
            return new JsonValueSerializer(valueMethod.getAnnotated(), ser);
        }
        Collection<BeanPropertyWriter> props = this.findBeanProperties(config, beanDesc);
        if (props == null || props.size() == 0) {
            return null;
        }
        return new BeanSerializer(type, props);
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        return ClassUtil.canBeABeanType(type) == null && !ClassUtil.isProxyType(type);
    }

    protected Collection<BeanPropertyWriter> findBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc) {
        boolean autodetect = config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_GETTERS);
        LinkedHashMap<String, AnnotatedMethod> methodsByProp = beanDesc.findGetters(autodetect);
        if (methodsByProp.isEmpty()) {
            return null;
        }
        boolean writeNulls = beanDesc.willWriteNullProperties(config.isEnabled(SerializationConfig.Feature.WRITE_NULL_PROPERTIES));
        ArrayList<BeanPropertyWriter> props = new ArrayList<BeanPropertyWriter>(methodsByProp.size());
        for (Map.Entry<String, AnnotatedMethod> en : methodsByProp.entrySet()) {
            AnnotatedMethod am = en.getValue();
            am.fixAccess();
            JsonSerializer<Object> ser = this.findSerializerFromAnnotation(am);
            Method m = am.getAnnotated();
            boolean methodNulls = am.willWriteNullProperties(writeNulls);
            props.add(new BeanPropertyWriter(en.getKey(), m, ser, methodNulls));
        }
        return props;
    }
}

