/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.lang.reflect.Method;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettableBeanProperty {
    final String _propName;
    final Method _setter;
    final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected Object _nullValue;

    public SettableBeanProperty(String propName, JavaType type, Method setter) {
        this._propName = propName.intern();
        this._type = type;
        this._setter = setter;
    }

    public void setValueDeserializer(JsonDeserializer<Object> deser) {
        if (this._valueDeserializer != null) {
            throw new IllegalStateException("Already had assigned deserializer for property '" + this._propName + "' (class " + this._setter.getDeclaringClass().getName() + ")");
        }
        this._valueDeserializer = deser;
        this._nullValue = this._valueDeserializer.getNullValue();
    }

    public String getPropertyName() {
        return this._propName;
    }

    public JavaType getType() {
        return this._type;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public final void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        Object value = this.deserialize(jp, ctxt);
        this.set(instance, value);
    }

    public final Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.nextToken();
        if (t == JsonToken.VALUE_NULL) {
            return this._nullValue;
        }
        return this._valueDeserializer.deserialize(jp, ctxt);
    }

    public final void set(Object instance, Object value) throws IOException, JsonProcessingException {
        try {
            this._setter.invoke(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
        }
    }

    protected void _throwAsIOE(Exception e, Object value) throws IOException {
        if (e instanceof IllegalArgumentException) {
            String actType = value == null ? "[NULL]" : value.getClass().getName();
            StringBuilder msg = new StringBuilder("Problem deserializing property '").append(this.getPropertyName());
            msg.append("' (expected type: ").append(this.getType());
            msg.append("; actual type: ").append(actType).append(")");
            String origMsg = e.getMessage();
            if (origMsg != null) {
                msg.append(", problem: ").append(origMsg);
            } else {
                msg.append(" (no error message provided)");
            }
            throw new JsonMappingException(msg.toString(), null, e);
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        Throwable th = e;
        while (th.getCause() != null) {
            th = th.getCause();
        }
        throw new JsonMappingException(th.getMessage(), null, th);
    }

    public String toString() {
        return "[property '" + this._propName + "]";
    }
}

