/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.deser.BasicDeserializerFactory;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.SettableAnyProperty;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.ThrowableDeserializer;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeserializerFactory
extends BasicDeserializerFactory {
    static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory();

    protected BeanDeserializerFactory() {
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationConfig config, JavaType type, DeserializerProvider p) throws JsonMappingException {
        JsonDeserializer<Object> deser = super.createBeanDeserializer(config, type, p);
        if (deser != null) {
            return deser;
        }
        Class beanClass = type.getRawClass();
        if (!this.isPotentialBeanType(beanClass)) {
            return null;
        }
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(beanClass);
        JsonDeserializer<Object> ad = this.findDeserializerFromAnnotation(beanDesc.getClassInfo());
        if (ad != null) {
            return ad;
        }
        if (!ClassUtil.isConcrete(beanClass)) {
            return null;
        }
        if (Throwable.class.isAssignableFrom(beanClass)) {
            return this.buildThrowableDeserializer(config, type, beanDesc);
        }
        return this.buildBeanDeserializer(config, type, beanDesc);
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc) throws JsonMappingException {
        BeanDeserializer deser = this.constructBeanDeserializerInstance(config, type, beanDesc);
        this.addDeserializerConstructors(config, beanDesc, deser);
        deser.validateConstructors();
        this.addBeanProps(config, beanDesc, deser);
        return deser;
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc) throws JsonMappingException {
        ThrowableDeserializer deser = this.constructThrowableDeserializerInstance(config, type, beanDesc);
        this.addDeserializerConstructors(config, beanDesc, deser);
        ((BeanDeserializer)deser).validateConstructors();
        this.addBeanProps(config, beanDesc, deser);
        AnnotatedMethod am = beanDesc.findMethod("initCause", INIT_CAUSE_PARAMS);
        if (am != null) {
            deser.addProperty(this.constructSettableProperty("cause", am));
        }
        deser.addIgnorable("localizedMessage");
        deser.addIgnorable("message");
        return deser;
    }

    protected BeanDeserializer constructBeanDeserializerInstance(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc) {
        return new BeanDeserializer(type);
    }

    protected ThrowableDeserializer constructThrowableDeserializerInstance(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc) {
        return new ThrowableDeserializer(type);
    }

    protected void addDeserializerConstructors(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializer deser) {
        BeanDeserializer.NumberConstructor nctor;
        BeanDeserializer.StringConstructor sctor;
        Class<?> beanClass = beanDesc.getBeanClass();
        Constructor<?> defaultCtor = beanDesc.findDefaultConstructor();
        if (defaultCtor != null) {
            deser.setDefaultConstructor(defaultCtor);
        }
        if ((sctor = this.getStringCreators(beanClass, beanDesc)) != null) {
            deser.setConstructor(sctor);
        }
        if ((nctor = this.getNumberCreators(beanClass, beanDesc)) != null) {
            deser.setConstructor(nctor);
        }
    }

    protected void addBeanProps(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializer deser) throws JsonMappingException {
        LinkedHashMap<String, AnnotatedMethod> methodsByProp = beanDesc.findSetters();
        AnnotatedMethod anyM = beanDesc.findAnySetter();
        if (anyM != null) {
            deser.setAnySetter(this.constructAnySetter(anyM));
        }
        for (Map.Entry en : methodsByProp.entrySet()) {
            deser.addProperty(this.constructSettableProperty((String)en.getKey(), (AnnotatedMethod)en.getValue()));
        }
    }

    protected SettableAnyProperty constructAnySetter(AnnotatedMethod am) throws JsonMappingException {
        am.fixAccess();
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(am);
        Type rawType = am.getGenericParameterTypes()[1];
        JavaType type = TypeFactory.fromType(rawType);
        Method m = am.getAnnotated();
        if (deser != null) {
            SettableAnyProperty prop = new SettableAnyProperty(type, m);
            prop.setValueDeserializer(deser);
            return prop;
        }
        type = this.modifyTypeByAnnotation(am, type);
        return new SettableAnyProperty(type, m);
    }

    protected SettableBeanProperty constructSettableProperty(String name, AnnotatedMethod am) throws JsonMappingException {
        am.fixAccess();
        Type rawType = am.getGenericParameterTypes()[0];
        JavaType type = TypeFactory.fromType(rawType);
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(am);
        Method m = am.getAnnotated();
        if (propDeser != null) {
            SettableBeanProperty prop = new SettableBeanProperty(name, type, m);
            prop.setValueDeserializer(propDeser);
            return prop;
        }
        type = this.modifyTypeByAnnotation(am, type);
        return new SettableBeanProperty(name, type, m);
    }

    BeanDeserializer.StringConstructor getStringCreators(Class<?> beanClass, BasicBeanDescription beanDesc) {
        Constructor<?> sctor = beanDesc.findSingleArgConstructor(String.class);
        Method factoryMethod = beanDesc.findFactoryMethod(String.class);
        return new BeanDeserializer.StringConstructor(beanClass, sctor, factoryMethod);
    }

    BeanDeserializer.NumberConstructor getNumberCreators(Class<?> beanClass, BasicBeanDescription beanDesc) {
        Constructor<?> intCtor = beanDesc.findSingleArgConstructor(Integer.TYPE, Integer.class);
        Constructor<?> longCtor = beanDesc.findSingleArgConstructor(Long.TYPE, Long.class);
        Method intFactoryMethod = beanDesc.findFactoryMethod(Integer.TYPE, Integer.class);
        Method longFactoryMethod = beanDesc.findFactoryMethod(Long.TYPE, Long.class);
        return new BeanDeserializer.NumberConstructor(beanClass, intCtor, longCtor, intFactoryMethod, longFactoryMethod);
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }
}

