/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateFormatHolder {
    static final String DATE_FORMAT_STR_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    static final String DATE_FORMAT_STR_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    static final SimpleDateFormat DATE_FORMAT_ISO8601;
    static final SimpleDateFormat DATE_FORMAT_RFC1123;
    DateFormat _formatISO8601;
    DateFormat _formatRFC1123;

    public static DateFormat getBlueprintISO8601Format() {
        return DATE_FORMAT_ISO8601;
    }

    public static DateFormat getISO8601Format(TimeZone tz) {
        DateFormat df = (DateFormat)DATE_FORMAT_ISO8601.clone();
        df.setTimeZone(tz);
        return df;
    }

    public static DateFormat getBlueprintRFC1123Format() {
        return DATE_FORMAT_RFC1123;
    }

    public static DateFormat getRFC1123Format(TimeZone tz) {
        DateFormat df = (DateFormat)DATE_FORMAT_RFC1123.clone();
        df.setTimeZone(tz);
        return df;
    }

    public Date parse(String dateStr) throws IllegalArgumentException {
        dateStr = dateStr.trim();
        DateFormat fmt = this.findLikeliestFormat(dateStr);
        try {
            return fmt.parse(dateStr);
        }
        catch (ParseException pex) {
            throw new IllegalArgumentException(String.format("Can not parse date \"%s\": not compatible with any of standard forms (\"%s\" or \"%s\")", dateStr, DATE_FORMAT_STR_ISO8601, DATE_FORMAT_STR_RFC1123), pex);
        }
    }

    protected DateFormat findLikeliestFormat(String dateStr) {
        if (dateStr.length() >= 5 && Character.isDigit(dateStr.charAt(0)) && Character.isDigit(dateStr.charAt(3)) && dateStr.charAt(4) == '-') {
            if (this._formatISO8601 == null) {
                this._formatISO8601 = (DateFormat)DATE_FORMAT_ISO8601.clone();
            }
            return this._formatISO8601;
        }
        if (this._formatRFC1123 == null) {
            this._formatRFC1123 = (DateFormat)DATE_FORMAT_RFC1123.clone();
        }
        return this._formatRFC1123;
    }

    static {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        DATE_FORMAT_ISO8601 = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601);
        DATE_FORMAT_ISO8601.setTimeZone(gmt);
        DATE_FORMAT_RFC1123 = new SimpleDateFormat(DATE_FORMAT_STR_RFC1123);
        DATE_FORMAT_RFC1123.setTimeZone(gmt);
    }
}

