/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ResolvableSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonValueSerializer
extends JsonSerializer<Object>
implements ResolvableSerializer {
    final Method _accessorMethod;
    JsonSerializer<Object> _serializer;

    public JsonValueSerializer(Method valueMethod, JsonSerializer<Object> ser) {
        this._accessorMethod = valueMethod;
        this._serializer = ser;
    }

    @Override
    public void serialize(Object bean, JsonGenerator jgen, SerializerProvider prov) throws IOException, JsonGenerationException {
        try {
            JsonSerializer<Object> ser;
            Object value = this._accessorMethod.invoke(bean, new Object[0]);
            if (value == null) {
                ser = prov.getNullValueSerializer();
            } else {
                ser = this._serializer;
                if (ser == null) {
                    ser = prov.findValueSerializer(value.getClass());
                }
            }
            ser.serialize(value, jgen, prov);
        }
        catch (Exception e) {
            Throwable t = e;
            while (t instanceof InvocationTargetException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw JsonMappingException.wrapWithPath(t, bean, this._accessorMethod.getName() + "()");
        }
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        Class<?> rt;
        if (this._serializer == null && Modifier.isFinal((rt = this._accessorMethod.getReturnType()).getModifiers())) {
            this._serializer = provider.findValueSerializer(rt);
        }
    }

    public String toString() {
        return "(@JsonValue serializer for method " + this._accessorMethod.getDeclaringClass() + "#" + this._accessorMethod.getName() + ")";
    }
}

