/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Method;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettableAnyProperty {
    final Method _setter;
    final JavaType _type;
    JsonDeserializer<Object> _valueDeserializer;

    public SettableAnyProperty(JavaType type, Method setter) {
        this._type = type;
        this._setter = setter;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public void setValueDeserializer(JsonDeserializer<Object> deser) {
        if (this._valueDeserializer != null) {
            throw new IllegalStateException("Already had assigned deserializer for SettableAnyProperty");
        }
        this._valueDeserializer = deser;
    }

    public JavaType getType() {
        return this._type;
    }

    public JsonDeserializer<Object> getValueDeserializer() {
        return this._valueDeserializer;
    }

    public void set(String propName, Object instance, Object value) throws JsonMappingException {
        try {
            this._setter.invoke(instance, propName, value);
        }
        catch (IllegalArgumentException iae) {
            String actType = value == null ? "[NULL]" : value.getClass().getName();
            StringBuilder msg = new StringBuilder("Problem deserializing \"any\" property '").append(propName);
            msg.append("' of class " + this.getClassName() + " (expected type: ").append(this._type);
            msg.append("; actual type: ").append(actType).append(")");
            String origMsg = iae.getMessage();
            if (origMsg != null) {
                msg.append(", problem: ").append(origMsg);
            } else {
                msg.append(" (no error message provided)");
            }
            throw new JsonMappingException(msg.toString(), null, iae);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            throw new JsonMappingException(t.getMessage(), null, t);
        }
    }

    public String toString() {
        return "[any property on class " + this.getClassName() + "]";
    }

    String getClassName() {
        return this._setter.getDeclaringClass().getName();
    }
}

