/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WritableBeanProperty {
    final String _name;
    final Method _accessorMethod;
    JsonSerializer<Object> _serializer = null;

    public WritableBeanProperty(String name, Method acc) {
        this._name = name;
        this._accessorMethod = acc;
    }

    public void assignSerializer(JsonSerializer<Object> ser) {
        if (this._serializer != null) {
            throw new IllegalStateException("Already had a serializer assigned");
        }
        this._serializer = ser;
    }

    public boolean hasSerializer() {
        return this._serializer != null;
    }

    public Class<?> getReturnType() {
        return this._accessorMethod.getReturnType();
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return "property '" + this.getName() + "' (via method " + this._accessorMethod.getDeclaringClass() + "#" + this._accessorMethod.getName() + "))";
    }

    public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws IOException, JsonGenerationException, IllegalAccessException, InvocationTargetException {
        JsonSerializer<Object> ser;
        Object value = this._accessorMethod.invoke(bean, new Object[0]);
        if (value == null) {
            ser = prov.getNullValueSerializer();
        } else {
            ser = this._serializer;
            if (ser == null) {
                ser = prov.findValueSerializer(value.getClass());
            }
        }
        jgen.writeFieldName(this._name);
        ser.serialize(value, jgen, prov);
    }
}

