/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.deser.StdDeserializers;
import org.codehaus.jackson.map.deser.StdKeyDeserializers;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.JavaType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.SimpleType;
import org.codehaus.jackson.map.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdDeserializerProvider
extends DeserializerProvider {
    static final JavaType _typeObject = TypeFactory.instance.fromClass(Object.class);
    static final JavaType _typeString = TypeFactory.instance.fromClass(String.class);
    static final HashMap<JavaType, JsonDeserializer<Object>> _simpleDeserializers = StdDeserializers.constructAll();
    static final HashMap<JavaType, KeyDeserializer> _keyDeserializers = StdKeyDeserializers.constructAll();
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 2);

    @Override
    public JsonDeserializer<Object> findValueDeserializer(JavaType type, DeserializerFactory f) {
        JsonDeserializer<Object> deser = this._findSimpleDeserializer(type);
        if (deser != null) {
            return deser;
        }
        deser = this._findCachedDeserializer(type);
        if (deser != null) {
            return deser;
        }
        deser = this._createDeserializer(f, type);
        if (deser == null) {
            deser = this._handleUnknownValueDeserializer(type, f);
        }
        if (deser instanceof ResolvableDeserializer) {
            this._cachedDeserializers.put(type, deser);
            this._resolveDeserializer((ResolvableDeserializer)((Object)deser), f);
        } else if (type.isEnumType()) {
            this._cachedDeserializers.put(type, deser);
        }
        return deser;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type) {
        if (_typeString.equals(type) || _typeObject.equals(type)) {
            return null;
        }
        KeyDeserializer kdes = _keyDeserializers.get(type);
        if (kdes != null) {
            return kdes;
        }
        if (type.isEnumType()) {
            return StdKeyDeserializers.constructEnumKeyDeserializer(type);
        }
        return this._handleUnknownKeyDeserializer(type);
    }

    protected JsonDeserializer<Object> _findSimpleDeserializer(JavaType type) {
        return _simpleDeserializers.get(type);
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type) {
        return this._cachedDeserializers.get(type);
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializerFactory f, JavaType type) {
        if (type.isEnumType()) {
            return f.createEnumDeserializer((SimpleType)type, this);
        }
        if (type instanceof ArrayType) {
            return f.createArrayDeserializer((ArrayType)type, this);
        }
        if (type instanceof MapType) {
            return f.createMapDeserializer((MapType)type, this);
        }
        if (type instanceof CollectionType) {
            return f.createCollectionDeserializer((CollectionType)type, this);
        }
        return f.createBeanDeserializer(type, this);
    }

    protected void _resolveDeserializer(ResolvableDeserializer ser, DeserializerFactory f) {
        ser.resolve(this, f);
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType type, DeserializerFactory f) {
        throw new IllegalArgumentException("Can not find a Value deserializer for type " + type);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType type) {
        throw new IllegalArgumentException("Can not find a (Map) Key deserializer for type " + type);
    }
}

