/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.type;

import org.codehaus.jackson.map.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapType
extends JavaType {
    final JavaType _keyType;
    final JavaType _valueType;
    final boolean _fullyTyped;

    private MapType(Class<?> mapType, JavaType keyT, JavaType valueT, boolean fullyTyped) {
        super(mapType);
        this._keyType = keyT;
        this._hashCode += keyT.hashCode();
        this._valueType = valueT;
        this._hashCode += valueT.hashCode();
        this._fullyTyped = fullyTyped;
    }

    public static MapType untyped(Class<?> rawType, JavaType keyT, JavaType valueT) {
        return new MapType(rawType, keyT, valueT, false);
    }

    public static MapType typed(Class<?> rawType, JavaType keyT, JavaType valueT) {
        return new MapType(rawType, keyT, valueT, keyT.isFullyTyped() & valueT.isFullyTyped());
    }

    @Override
    public boolean isFullyTyped() {
        return this._fullyTyped;
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    public JavaType getKeyType() {
        return this._keyType;
    }

    public JavaType getValueType() {
        return this._valueType;
    }

    @Override
    public String toString() {
        return "[map type, " + this._keyType + " -> " + this._valueType + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        MapType other = (MapType)o;
        return this._keyType.equals(other._keyType) && this._valueType.equals(other._valueType);
    }
}

