/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonNode;
import org.codehaus.jackson.map.node.TreeMapperBase;

public class TreeMapper
extends TreeMapperBase {
    public TreeMapper() {
        this(null);
    }

    public TreeMapper(JsonFactory jf) {
        super(jf);
    }

    public JsonNode readTree(File src) throws IOException, JsonParseException {
        return this._readMapAndClose(this._jsonFactory.createJsonParser(src));
    }

    public JsonNode readTree(URL src) throws IOException, JsonParseException {
        return this._readMapAndClose(this._jsonFactory.createJsonParser(src));
    }

    public JsonNode readTree(InputStream src) throws IOException, JsonParseException {
        return this._readMapAndClose(this._jsonFactory.createJsonParser(src));
    }

    public JsonNode readTree(Reader src) throws IOException, JsonParseException {
        return this._readMapAndClose(this._jsonFactory.createJsonParser(src));
    }

    public JsonNode readTree(String jsonContent) throws IOException, JsonParseException {
        return this._readMapAndClose(this._jsonFactory.createJsonParser(jsonContent));
    }

    public JsonNode readTree(byte[] jsonContent) throws IOException, JsonParseException {
        return this._readMapAndClose(this._jsonFactory.createJsonParser(jsonContent));
    }

    public JsonNode readTree(JsonParser jp) throws IOException, JsonParseException, JsonMappingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == null && (curr = jp.nextToken()) == null) {
            return null;
        }
        JsonNode result = this.readAndMap(jp, curr);
        jp.nextToken();
        return result;
    }

    public void writeTree(JsonNode rootNode, File dst) throws IOException, JsonParseException {
        this._writeNodeAndClose(this._jsonFactory.createJsonGenerator(dst, JsonEncoding.UTF8), rootNode);
    }

    public void writeTree(JsonNode rootNode, Writer dst) throws IOException, JsonParseException {
        this._writeNodeAndClose(this._jsonFactory.createJsonGenerator(dst), rootNode);
    }

    public void writeTree(JsonNode rootNode, OutputStream dst) throws IOException, JsonParseException {
        this._writeNodeAndClose(this._jsonFactory.createJsonGenerator(dst, JsonEncoding.UTF8), rootNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonNode _readMapAndClose(JsonParser jp) throws IOException, JsonParseException {
        try {
            JsonNode jsonNode = this.readTree(jp);
            return jsonNode;
        }
        finally {
            try {
                jp.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _writeNodeAndClose(JsonGenerator jg, JsonNode rootNode) throws IOException, JsonParseException {
        try {
            rootNode.writeTo(jg);
        }
        finally {
            try {
                jg.close();
            }
            catch (IOException iOException) {}
        }
    }
}

