/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.BaseMapper;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.legacy.JavaTypeSerializer;
import org.codehaus.jackson.map.legacy.KnownClasses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeMapper
extends ObjectMapper
implements JavaTypeSerializer<Object> {
    public JavaTypeMapper() {
        this(null);
    }

    public JavaTypeMapper(JsonFactory jf) {
        this(jf, null, null);
    }

    public JavaTypeMapper(JsonFactory jf, SerializerProvider sp, DeserializerProvider dp) {
        super(jf, sp, dp);
    }

    public Object read(JsonParser jp) throws IOException, JsonParseException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == null && (curr = jp.nextToken()) == null) {
            return null;
        }
        Object result = this._readAndMap(jp, curr);
        jp.nextToken();
        return result;
    }

    public void writeAny(JsonGenerator jg, Object value) throws IOException, JsonGenerationException {
        this.writeAny((JavaTypeSerializer<Object>)this, jg, value);
        jg.flush();
    }

    protected Object _readAndMap(JsonParser jp, JsonToken currToken) throws IOException, JsonParseException {
        switch (currToken) {
            case START_OBJECT: {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                while ((currToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                    if (currToken != JsonToken.FIELD_NAME) {
                        this._reportProblem(jp, "Unexpected token (" + currToken + "), expected FIELD_NAME");
                    }
                    String fieldName = jp.getText();
                    Object value = this._readAndMap(jp, jp.nextToken());
                    if (this._cfgDupFields == BaseMapper.DupFields.ERROR) {
                        Object old = result.put(fieldName, value);
                        if (old == null) continue;
                        this._reportProblem(jp, "Duplicate value for field '" + fieldName + "', when dup fields mode is " + (Object)((Object)this._cfgDupFields));
                        continue;
                    }
                    if (this._cfgDupFields == BaseMapper.DupFields.USE_LAST) {
                        result.put(fieldName, value);
                        continue;
                    }
                    if (result.containsKey(fieldName)) continue;
                    result.put(fieldName, value);
                }
                return result;
            }
            case START_ARRAY: {
                ArrayList<Object> result = new ArrayList<Object>();
                while ((currToken = jp.nextToken()) != JsonToken.END_ARRAY) {
                    Object value = this._readAndMap(jp, currToken);
                    result.add(value);
                }
                return result;
            }
            case VALUE_STRING: {
                return jp.getText();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return jp.getNumberValue();
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_NULL: {
                return null;
            }
            case FIELD_NAME: 
            case END_OBJECT: 
            case END_ARRAY: {
                this._reportProblem(jp, "Can not map token " + currToken + ": stream off by a token or two?");
            }
        }
        this._throwInternal("Unrecognized event type: " + currToken);
        return null;
    }

    @Override
    public final boolean writeAny(JavaTypeSerializer<Object> defaultSerializer, JsonGenerator jgen, Object value) throws IOException, JsonGenerationException {
        if (value == null) {
            jgen.writeNull();
            return true;
        }
        KnownClasses.JdkClasses jdkType = KnownClasses.findTypeFast(value);
        if (jdkType == null && (jdkType = KnownClasses.findTypeSlow(value)) == null) {
            throw new JsonGenerationException("Unknown type (" + value.getClass().getName() + "): don't know how to handle");
        }
        switch (jdkType) {
            case BOOLEAN: {
                jgen.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case STRING: 
            case STRING_LIKE: {
                jgen.writeString(value.toString());
                break;
            }
            case NUMBER_INTEGER: {
                jgen.writeNumber(((Number)value).intValue());
                break;
            }
            case NUMBER_LONG: {
                jgen.writeNumber(((Number)value).longValue());
                break;
            }
            case NUMBER_DOUBLE: {
                jgen.writeNumber(((Number)value).doubleValue());
                break;
            }
            case NUMBER_OTHER: {
                jgen.writeNumber(value.toString());
                break;
            }
            case ARRAY_LONG: {
                jgen.writeStartArray();
                long[] values = (long[])value;
                int len = values.length;
                for (int i = 0; i < len; ++i) {
                    jgen.writeNumber(values[i]);
                }
                jgen.writeEndArray();
                break;
            }
            case ARRAY_INT: {
                jgen.writeStartArray();
                int[] values = (int[])value;
                int len = values.length;
                for (int i = 0; i < len; ++i) {
                    jgen.writeNumber(values[i]);
                }
                jgen.writeEndArray();
                break;
            }
            case ARRAY_SHORT: {
                jgen.writeStartArray();
                short[] values = (short[])value;
                int len = values.length;
                for (int i = 0; i < len; ++i) {
                    jgen.writeNumber((int)values[i]);
                }
                jgen.writeEndArray();
                break;
            }
            case ARRAY_CHAR: {
                char[] text = (char[])value;
                jgen.writeString(text, 0, text.length);
                jgen.writeEndArray();
                break;
            }
            case ARRAY_BYTE: {
                byte[] data = (byte[])value;
                jgen.writeBinary(data, 0, data.length);
                break;
            }
            case ARRAY_DOUBLE: {
                jgen.writeStartArray();
                double[] values = (double[])value;
                int len = values.length;
                for (int i = 0; i < len; ++i) {
                    jgen.writeNumber(values[i]);
                }
                jgen.writeEndArray();
                break;
            }
            case ARRAY_FLOAT: {
                jgen.writeStartArray();
                float[] values = (float[])value;
                int len = values.length;
                for (int i = 0; i < len; ++i) {
                    jgen.writeNumber(values[i]);
                }
                jgen.writeEndArray();
                break;
            }
            case ARRAY_BOOLEAN: {
                jgen.writeStartArray();
                boolean[] values = (boolean[])value;
                int len = values.length;
                for (int i = 0; i < len; ++i) {
                    jgen.writeBoolean(values[i]);
                }
                jgen.writeEndArray();
                break;
            }
            case ARRAY_OBJECT: {
                return this._writeValue(defaultSerializer, jgen, (Object[])value);
            }
            case MAP: {
                return this._writeValue(defaultSerializer, jgen, (Map)value);
            }
            case LIST_INDEXED: {
                jgen.writeStartArray();
                List l = (List)value;
                int len = l.size();
                for (int i = 0; i < len; ++i) {
                    this.writeAny(defaultSerializer, jgen, l.get(i));
                }
                jgen.writeEndArray();
                break;
            }
            case LIST_OTHER: 
            case COLLECTION: {
                return this._writeValue(defaultSerializer, jgen, (Collection)value);
            }
            case ITERABLE: {
                jgen.writeStartArray();
                for (Object elem : (Iterable)value) {
                    this.writeAny(defaultSerializer, jgen, elem);
                }
                jgen.writeEndArray();
                break;
            }
            case ITERATOR: {
                jgen.writeStartArray();
                Iterator it = (Iterator)value;
                while (it.hasNext()) {
                    this.writeAny(defaultSerializer, jgen, it.next());
                }
                jgen.writeEndArray();
                break;
            }
            default: {
                throw new RuntimeException("Internal error: unhandled internal type: " + (Object)((Object)jdkType));
            }
        }
        return true;
    }

    public boolean _writeValue(JavaTypeSerializer<Object> defaultSerializer, JsonGenerator jgen, Map<?, ?> value) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        for (Map.Entry<?, ?> me : value.entrySet()) {
            jgen.writeFieldName(me.getKey().toString());
            this.writeAny(defaultSerializer, jgen, me.getValue());
        }
        jgen.writeEndObject();
        return true;
    }

    public boolean _writeValue(JavaTypeSerializer<Object> defaultSerializer, JsonGenerator jgen, Collection<?> values) throws IOException, JsonGenerationException {
        jgen.writeStartArray();
        if (!values.isEmpty()) {
            for (Object ob : values) {
                this.writeAny(defaultSerializer, jgen, ob);
            }
        }
        jgen.writeEndArray();
        return true;
    }

    public boolean _writeValue(JavaTypeSerializer<Object> defaultSerializer, JsonGenerator jgen, Object[] values) throws IOException, JsonGenerationException {
        jgen.writeStartArray();
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            this.writeAny(defaultSerializer, jgen, values[i]);
        }
        jgen.writeEndArray();
        return true;
    }
}

