/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.AnnotationMap;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedConstructor
extends Annotated {
    final Constructor<?> _constructor;
    final AnnotationMap _classAnnotations;
    final AnnotationMap[] _paramAnnotations;

    public AnnotatedConstructor(Constructor<?> constructor, AnnotationMap annMap, AnnotationMap[] paramAnnotations) {
        this._constructor = constructor;
        this._classAnnotations = annMap;
        this._paramAnnotations = paramAnnotations;
    }

    public void addOrOverride(Annotation a) {
        this._classAnnotations.add(a);
    }

    public void addOrOverrideParam(int paramIndex, Annotation a) {
        AnnotationMap old = this._paramAnnotations[paramIndex];
        if (old == null) {
            this._paramAnnotations[paramIndex] = old = new AnnotationMap();
        }
        old.add(a);
    }

    @Override
    public Constructor<?> getAnnotated() {
        return this._constructor;
    }

    @Override
    public int getModifiers() {
        return this._constructor.getModifiers();
    }

    @Override
    public String getName() {
        return this._constructor.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._classAnnotations.get(acls);
    }

    @Override
    public Class<?> getType() {
        return this._constructor.getDeclaringClass();
    }

    public AnnotatedParameter getParameter(int index) {
        return new AnnotatedParameter(this.getParameterType(index), this._paramAnnotations[index]);
    }

    public int getParameterCount() {
        return this._constructor.getParameterTypes().length;
    }

    public Class<?> getParameterClass(int index) {
        Class<?>[] types = this._constructor.getParameterTypes();
        return index >= types.length ? null : types[index];
    }

    public Type getParameterType(int index) {
        Type[] types = this._constructor.getGenericParameterTypes();
        return index >= types.length ? null : types[index];
    }

    public AnnotationMap getParameterAnnotations(int index) {
        if (this._paramAnnotations != null && index >= 0 && index <= this._paramAnnotations.length) {
            return this._paramAnnotations[index];
        }
        return null;
    }

    public void fixAccess() {
        ClassUtil.checkAndFixAccess(this._constructor);
    }

    public String toString() {
        return "[constructor for " + this.getName() + ", annotations: " + this._classAnnotations + "]";
    }
}

