/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.Base64Variants;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.ClassIntrospector;
import org.codehaus.jackson.map.DeserializationProblemHandler;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.NopAnnotationIntrospector;
import org.codehaus.jackson.map.type.ClassKey;
import org.codehaus.jackson.map.util.LinkedNode;
import org.codehaus.jackson.map.util.StdDateFormat;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeserializationConfig
implements MapperConfig {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    protected static final DateFormat DEFAULT_DATE_FORMAT = StdDateFormat.instance;
    protected ClassIntrospector<? extends BeanDescription> _classIntrospector;
    protected AnnotationIntrospector _annotationIntrospector;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected LinkedNode<DeserializationProblemHandler> _problemHandlers;
    protected DateFormat _dateFormat = DEFAULT_DATE_FORMAT;
    HashMap<ClassKey, Class<?>> _mixInAnnotations;
    protected boolean _mixInAnnotationsShared;

    public DeserializationConfig(ClassIntrospector<? extends BeanDescription> intr, AnnotationIntrospector annIntr) {
        this._classIntrospector = intr;
        this._annotationIntrospector = annIntr;
    }

    protected DeserializationConfig(DeserializationConfig src, HashMap<ClassKey, Class<?>> mixins) {
        this._classIntrospector = src._classIntrospector;
        this._annotationIntrospector = src._annotationIntrospector;
        this._featureFlags = src._featureFlags;
        this._problemHandlers = src._problemHandlers;
        this._dateFormat = src._dateFormat;
        this._mixInAnnotations = mixins;
    }

    @Override
    public void fromAnnotations(Class<?> cls) {
        AnnotatedClass ac = AnnotatedClass.construct(cls, this._annotationIntrospector, null);
        Boolean ad = this._annotationIntrospector.findSetterAutoDetection(ac);
        if (ad != null) {
            this.set(Feature.AUTO_DETECT_SETTERS, ad);
        }
        if ((ad = this._annotationIntrospector.findCreatorAutoDetection(ac)) != null) {
            this.set(Feature.AUTO_DETECT_CREATORS, ad);
        }
    }

    @Override
    public DeserializationConfig createUnshared() {
        HashMap<ClassKey, Class<?>> mixins = this._mixInAnnotations;
        this._mixInAnnotationsShared = true;
        return new DeserializationConfig(this, mixins);
    }

    @Override
    public void setIntrospector(ClassIntrospector<? extends BeanDescription> i) {
        this._classIntrospector = i;
    }

    @Override
    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(Feature.USE_ANNOTATIONS)) {
            return this._annotationIntrospector;
        }
        return NopAnnotationIntrospector.instance;
    }

    @Override
    public void setAnnotationIntrospector(AnnotationIntrospector introspector) {
        this._annotationIntrospector = introspector;
    }

    @Override
    public void setMixInAnnotations(Map<Class<?>, Class<?>> sourceMixins) {
        HashMap mixins = null;
        if (sourceMixins != null && sourceMixins.size() > 0) {
            mixins = new HashMap(sourceMixins.size());
            for (Map.Entry<Class<?>, Class<?>> en : sourceMixins.entrySet()) {
                mixins.put(new ClassKey(en.getKey()), en.getValue());
            }
        }
        this._mixInAnnotationsShared = false;
        this._mixInAnnotations = mixins;
    }

    @Override
    public void addMixInAnnotations(Class<?> target, Class<?> mixinSource) {
        if (this._mixInAnnotations == null || this._mixInAnnotationsShared) {
            this._mixInAnnotationsShared = false;
            this._mixInAnnotations = new HashMap();
        }
        this._mixInAnnotations.put(new ClassKey(target), mixinSource);
    }

    @Override
    public Class<?> findMixInClassFor(Class<?> cls) {
        return this._mixInAnnotations == null ? null : this._mixInAnnotations.get(new ClassKey(cls));
    }

    public void addHandler(DeserializationProblemHandler h) {
        if (!LinkedNode.contains(this._problemHandlers, h)) {
            this._problemHandlers = new LinkedNode<DeserializationProblemHandler>(h, this._problemHandlers);
        }
    }

    public void clearHandlers() {
        this._problemHandlers = null;
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public Base64Variant getBase64Variant() {
        return Base64Variants.getDefaultVariant();
    }

    public LinkedNode<DeserializationProblemHandler> getProblemHandlers() {
        return this._problemHandlers;
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public <T extends BeanDescription> T introspect(JavaType type) {
        return (T)this._classIntrospector.forDeserialization(this, type, this);
    }

    public <T extends BeanDescription> T introspectForCreation(Class<?> cls) {
        return (T)this._classIntrospector.forCreation(this, cls, this);
    }

    public <T extends BeanDescription> T introspectClassAnnotations(Class<?> cls) {
        return (T)this._classIntrospector.forClassAnnotations(this, cls, this);
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public void setDateFormat(DateFormat df) {
        this._dateFormat = df == null ? StdDateFormat.instance : df;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        USE_ANNOTATIONS(true),
        AUTO_DETECT_SETTERS(true),
        AUTO_DETECT_CREATORS(true),
        AUTO_DETECT_FIELDS(true),
        USE_GETTERS_AS_SETTERS(true),
        CAN_OVERRIDE_ACCESS_MODIFIERS(true),
        USE_BIG_DECIMAL_FOR_FLOATS(false),
        USE_BIG_INTEGER_FOR_INTS(false),
        FAIL_ON_UNKNOWN_PROPERTIES(true);

        final boolean _defaultState;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

