/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanDeserializer
extends JsonDeserializer<Object>
implements ResolvableDeserializer {
    final JavaType _beanType;
    final Constructor<?> _defaultConstructor;
    final HashMap<String, SettableBeanProperty> _props;
    HashSet<String> _ignorableProps;
    final StringConstructor _stringConstructor;
    final NumberConstructor _numberConstructor;

    public BeanDeserializer(JavaType type, Constructor<?> defaultCtor, StringConstructor sctor, NumberConstructor nctor) {
        this._beanType = type;
        this._defaultConstructor = defaultCtor;
        this._stringConstructor = sctor;
        this._numberConstructor = nctor;
        this._props = new HashMap();
        this._ignorableProps = null;
    }

    protected SettableBeanProperty addSetter(SettableBeanProperty prop) {
        return this._props.put(prop.getPropertyName(), prop);
    }

    protected void addIgnorable(String propName) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(propName);
    }

    @Override
    public void resolve(DeserializerProvider provider) throws JsonMappingException {
        HashMap<JavaType, JsonDeserializer<Object>> seen = null;
        for (SettableBeanProperty prop : this._props.values()) {
            if (prop.hasValueDeserializer()) continue;
            JavaType type = prop.getType();
            JsonDeserializer<Object> deser = null;
            if (seen != null) {
                deser = (JsonDeserializer<Object>)seen.get(type);
            }
            if (deser == null && (deser = provider.findValueDeserializer(type, this._beanType, prop.getPropertyName())) instanceof BeanDeserializer) {
                if (seen == null) {
                    seen = new HashMap<JavaType, JsonDeserializer<Object>>();
                }
                seen.put(type, deser);
            }
            prop.setValueDeserializer(deser);
        }
    }

    public Class<?> getBeanClass() {
        return this._beanType.getRawClass();
    }

    @Override
    public final Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object value;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            return this.deserializeFromObject(jp, ctxt);
        }
        if (t == JsonToken.VALUE_STRING && (value = this._stringConstructor.construct(jp.getText())) != null) {
            return value;
        }
        if (t.isNumeric()) {
            value = null;
            switch (jp.getNumberType()) {
                case INT: {
                    value = this._numberConstructor.construct(jp.getIntValue());
                    break;
                }
                case LONG: {
                    value = this._numberConstructor.construct(jp.getLongValue());
                }
            }
            if (value != null) {
                return value;
            }
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    public final Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object result;
        if (this._defaultConstructor == null) {
            throw JsonMappingException.from(jp, "No default constructor found for type " + this._beanType + ": can not instantiate from Json object");
        }
        try {
            result = this._defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            BeanDeserializer._rethrow(e);
            return null;
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            JsonToken t = jp.nextToken();
            SettableBeanProperty prop = this._props.get(propName);
            if (prop != null) {
                JsonDeserializer<Object> valueDeser = prop.getValueDeserializer();
                Object value = t == JsonToken.VALUE_NULL ? null : valueDeser.deserialize(jp, ctxt);
                prop.set(result, value);
                continue;
            }
            if (this._ignorableProps == null || !this._ignorableProps.contains(propName)) {
                this.reportUnknownField(jp, ctxt, result, propName);
            }
            jp.skipChildren();
        }
        return result;
    }

    protected void reportUnknownField(JsonParser jp, DeserializationContext ctxt, Object valueObject, String fieldName) throws IOException, JsonProcessingException {
        throw ctxt.unknownFieldException(valueObject, fieldName);
    }

    protected static void _rethrow(Exception e) throws RuntimeException {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        throw new IllegalArgumentException(t.getMessage(), t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NumberConstructor
    extends ConstructorBase {
        protected final Constructor<?> _intCtor;
        protected final Constructor<?> _longCtor;
        protected final Method _intFactoryMethod;
        protected final Method _longFactoryMethod;

        public NumberConstructor(Class<?> valueClass, Constructor<?> intCtor, Constructor<?> longCtor, Method ifm, Method lfm) {
            super(valueClass);
            this._intCtor = intCtor;
            this._longCtor = longCtor;
            this._intFactoryMethod = ifm;
            this._longFactoryMethod = lfm;
        }

        public Object construct(int value) {
            try {
                if (this._intCtor != null) {
                    return this._intCtor.newInstance(value);
                }
                if (this._intFactoryMethod != null) {
                    return this._intFactoryMethod.invoke((Object)this._valueClass, value);
                }
            }
            catch (Exception e) {
                BeanDeserializer._rethrow(e);
            }
            return this.construct((long)value);
        }

        public Object construct(long value) {
            try {
                if (this._longCtor != null) {
                    return this._longCtor.newInstance(value);
                }
                if (this._longFactoryMethod != null) {
                    return this._longFactoryMethod.invoke((Object)this._valueClass, value);
                }
            }
            catch (Exception e) {
                BeanDeserializer._rethrow(e);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringConstructor
    extends ConstructorBase {
        protected final Method _factoryMethod;
        protected final Constructor<?> _ctor;

        public StringConstructor(Class<?> valueClass, Constructor<?> ctor, Method factoryMethod) {
            super(valueClass);
            this._ctor = ctor;
            this._factoryMethod = factoryMethod;
        }

        public Object construct(String value) {
            try {
                if (this._ctor != null) {
                    return this._ctor.newInstance(value);
                }
                if (this._factoryMethod != null) {
                    return this._factoryMethod.invoke((Object)this._valueClass, value);
                }
            }
            catch (Exception e) {
                BeanDeserializer._rethrow(e);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstructorBase {
        protected final Class<?> _valueClass;

        public ConstructorBase(Class<?> valueClass) {
            this._valueClass = valueClass;
        }
    }
}

