/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class StdDateFormat
extends DateFormat {
    static final String DATE_FORMAT_STR_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    static final String DATE_FORMAT_STR_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    static final SimpleDateFormat DATE_FORMAT_ISO8601;
    static final SimpleDateFormat DATE_FORMAT_RFC1123;
    public static final StdDateFormat instance;
    transient DateFormat _formatISO8601;
    transient DateFormat _formatRFC1123;

    public StdDateFormat clone() {
        return new StdDateFormat();
    }

    public static DateFormat getBlueprintISO8601Format() {
        return DATE_FORMAT_ISO8601;
    }

    public static DateFormat getISO8601Format(TimeZone tz) {
        DateFormat df = (DateFormat)DATE_FORMAT_ISO8601.clone();
        df.setTimeZone(tz);
        return df;
    }

    public static DateFormat getBlueprintRFC1123Format() {
        return DATE_FORMAT_RFC1123;
    }

    public static DateFormat getRFC1123Format(TimeZone tz) {
        DateFormat df = (DateFormat)DATE_FORMAT_RFC1123.clone();
        df.setTimeZone(tz);
        return df;
    }

    public Date parse(String dateStr) throws ParseException {
        ParsePosition pos;
        Date result = this.parse(dateStr = dateStr.trim(), pos = new ParsePosition(0));
        if (result == null) {
            throw new ParseException(String.format("Can not parse date \"%s\": not compatible with any of standard forms (\"%s\" or \"%s\")", dateStr, DATE_FORMAT_STR_ISO8601, DATE_FORMAT_STR_RFC1123), pos.getErrorIndex());
        }
        return result;
    }

    public Date parse(String dateStr, ParsePosition pos) {
        return this.findLikeliestFormat(dateStr).parse(dateStr, pos);
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (this._formatISO8601 == null) {
            this._formatISO8601 = (DateFormat)DATE_FORMAT_ISO8601.clone();
        }
        return this._formatISO8601.format(date, toAppendTo, fieldPosition);
    }

    protected DateFormat findLikeliestFormat(String dateStr) {
        if (dateStr.length() >= 5 && Character.isDigit(dateStr.charAt(0)) && Character.isDigit(dateStr.charAt(3)) && dateStr.charAt(4) == '-') {
            if (this._formatISO8601 == null) {
                this._formatISO8601 = (DateFormat)DATE_FORMAT_ISO8601.clone();
            }
            return this._formatISO8601;
        }
        if (this._formatRFC1123 == null) {
            this._formatRFC1123 = (DateFormat)DATE_FORMAT_RFC1123.clone();
        }
        return this._formatRFC1123;
    }

    static {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        DATE_FORMAT_ISO8601 = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601);
        DATE_FORMAT_ISO8601.setTimeZone(gmt);
        DATE_FORMAT_RFC1123 = new SimpleDateFormat(DATE_FORMAT_STR_RFC1123);
        DATE_FORMAT_RFC1123.setTimeZone(gmt);
        instance = new StdDateFormat();
    }
}

