/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedMethodMap;
import org.codehaus.jackson.map.introspect.AnnotationFilter;
import org.codehaus.jackson.map.introspect.AnnotationMap;
import org.codehaus.jackson.map.introspect.MethodFilter;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedClass
extends Annotated {
    final Class<?> _class;
    final Collection<Class<?>> _superTypes;
    final AnnotationFilter _annotationFilter;
    AnnotationMap _classAnnotations;
    AnnotatedConstructor _defaultConstructor;
    List<AnnotatedConstructor> _singleArgConstructors;
    List<AnnotatedMethod> _singleArgStaticMethods;
    AnnotatedMethodMap _memberMethods;

    private AnnotatedClass(Class<?> cls, List<Class<?>> superTypes, AnnotationFilter af) {
        this._class = cls;
        this._superTypes = superTypes;
        this._annotationFilter = af;
    }

    public static AnnotatedClass constructFull(Class<?> cls, AnnotationFilter annotationFilter, boolean includeCreators, MethodFilter memberFilter) {
        List<Class<?>> st = ClassUtil.findSuperTypes(cls, null);
        AnnotatedClass ac = new AnnotatedClass(cls, st, annotationFilter);
        ac.resolveClassAnnotations();
        if (includeCreators) {
            ac.resolveCreators();
        }
        if (memberFilter != null) {
            ac.resolveMemberMethods(memberFilter);
        }
        return ac;
    }

    private void resolveClassAnnotations() {
        this._classAnnotations = new AnnotationMap();
        for (Annotation a : this._class.getDeclaredAnnotations()) {
            this._classAnnotations.add(a);
        }
        for (Class<?> cls : this._superTypes) {
            for (Annotation a : cls.getDeclaredAnnotations()) {
                this._classAnnotations.addIfNotPresent(a);
            }
        }
    }

    private void resolveCreators() {
        this._singleArgConstructors = null;
        block4: for (Constructor<?> constructor : this._class.getDeclaredConstructors()) {
            switch (constructor.getParameterTypes().length) {
                case 0: {
                    this._defaultConstructor = new AnnotatedConstructor(constructor);
                    continue block4;
                }
                case 1: {
                    if (this._singleArgConstructors == null) {
                        this._singleArgConstructors = new ArrayList<AnnotatedConstructor>();
                    }
                    this._singleArgConstructors.add(new AnnotatedConstructor(constructor));
                }
            }
        }
        this._singleArgStaticMethods = null;
        for (Executable executable : this._class.getDeclaredMethods()) {
            int argCount;
            if (!Modifier.isStatic(((Method)executable).getModifiers()) || (argCount = ((Method)executable).getParameterTypes().length) != 1) continue;
            if (this._singleArgStaticMethods == null) {
                this._singleArgStaticMethods = new ArrayList<AnnotatedMethod>();
            }
            this._singleArgStaticMethods.add(new AnnotatedMethod((Method)executable));
        }
    }

    private void resolveMemberMethods(MethodFilter methodFilter) {
        this._memberMethods = new AnnotatedMethodMap();
        for (Method m : this._class.getDeclaredMethods()) {
            if (m.isSynthetic() || m.isBridge() || !methodFilter.includeMethod(m)) continue;
            this._memberMethods.add(new AnnotatedMethod(m));
        }
        for (Class<?> cls : this._superTypes) {
            for (Method m : cls.getDeclaredMethods()) {
                if (m.isSynthetic() || m.isBridge() || !methodFilter.includeMethod(m)) continue;
                AnnotatedMethod am = this._memberMethods.find(m);
                if (am == null) {
                    am = new AnnotatedMethod(m);
                    this._memberMethods.add(am);
                    continue;
                }
                am.addAnnotationsNotPresent(m);
            }
        }
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (this._classAnnotations == null) {
            return null;
        }
        return this._classAnnotations.get(acls);
    }

    public AnnotatedConstructor getDefaultConstructor() {
        return this._defaultConstructor;
    }

    public Collection<AnnotatedConstructor> getSingleArgConstructors() {
        if (this._singleArgConstructors != null) {
            return this._singleArgConstructors;
        }
        return Collections.emptyList();
    }

    public Collection<AnnotatedMethod> getSingleArgStaticMethods() {
        if (this._singleArgStaticMethods != null) {
            return this._singleArgStaticMethods;
        }
        return Collections.emptyList();
    }

    public Collection<AnnotatedMethod> getMemberMethods() {
        return this._memberMethods.getMethods();
    }

    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        return this._memberMethods.find(name, paramTypes);
    }

    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }

    public static final class FactoryMethodFilter
    implements MethodFilter {
        public static final FactoryMethodFilter instance = new FactoryMethodFilter();

        public boolean includeMethod(Method m) {
            if (!Modifier.isStatic(m.getModifiers())) {
                return false;
            }
            int argCount = m.getParameterTypes().length;
            if (argCount != 1) {
                return false;
            }
            Class<?> rt = m.getReturnType();
            return rt != Void.TYPE;
        }
    }
}

