/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.node;

import java.io.IOException;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.io.NumberOutput;
import org.codehaus.jackson.node.NumericNode;

public final class LongNode
extends NumericNode {
    final long mValue;

    public LongNode(long v) {
        this.mValue = v;
    }

    public static LongNode valueOf(long l) {
        return new LongNode(l);
    }

    public boolean isIntegralNumber() {
        return true;
    }

    public boolean isLong() {
        return true;
    }

    public Number getNumberValue() {
        return this.mValue;
    }

    public int getIntValue() {
        return (int)this.mValue;
    }

    public long getLongValue() {
        return this.mValue;
    }

    public double getDoubleValue() {
        return this.mValue;
    }

    public BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this.mValue);
    }

    public String getValueAsText() {
        return NumberOutput.toString((long)this.mValue);
    }

    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeNumber(this.mValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return ((LongNode)((Object)o)).mValue == this.mValue;
    }

    public int hashCode() {
        return (int)this.mValue ^ (int)(this.mValue >> 32);
    }
}

