/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private ClassUtil() {
    }

    public static String canBeABeanType(Class<?> type) {
        if (type.isAnnotation()) {
            return "annotation";
        }
        if (type.isArray()) {
            return "array";
        }
        if (type.isEnum()) {
            return "enum";
        }
        if (type.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> type) {
        if (type.getEnclosingMethod() != null) {
            return "local/anonymous";
        }
        if (type.getEnclosingClass() != null && !Modifier.isStatic(type.getModifiers())) {
            return "non-static member class";
        }
        return null;
    }

    public static boolean isProxyType(Class<?> type) {
        if (Proxy.isProxyClass(type)) {
            return true;
        }
        String name = type.getName();
        return name.startsWith("net.sf.cglib.proxy.") || name.startsWith("org.hibernate.proxy.");
    }

    public static void checkAndFixAccess(AccessibleObject obj, Class<?> declClass) {
        try {
            obj.setAccessible(true);
        }
        catch (SecurityException se) {
            throw new IllegalArgumentException("Can not access " + obj + " (from class " + declClass.getName() + "; failed to set access: " + se.getMessage());
        }
    }

    public static String manglePropertyName(String basename) {
        char lower;
        char upper;
        int len = basename.length();
        if (len == 0) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < len && (upper = basename.charAt(i)) != (lower = Character.toLowerCase(upper)); ++i) {
            if (sb == null) {
                sb = new StringBuilder(basename);
            }
            sb.setCharAt(i, lower);
        }
        return sb == null ? basename : sb.toString();
    }

    public static String descFor(AnnotatedElement elem) {
        if (elem instanceof Class) {
            return "class " + ((Class)elem).getName();
        }
        if (elem instanceof Method) {
            Method m = (Method)elem;
            return "method " + m.getName() + " (from class " + m.getDeclaringClass().getName() + ")";
        }
        if (elem instanceof Constructor) {
            Constructor ctor = (Constructor)elem;
            return "constructor() (from class " + ctor.getDeclaringClass().getName() + ")";
        }
        return "unknown type [" + elem.getClass() + "]";
    }
}

