/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonUseSerializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.codehaus.jackson.map.ser.StdSerializerFactory;
import org.codehaus.jackson.map.ser.WritableBeanProperty;
import org.codehaus.jackson.map.type.ClassIntrospector;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializerFactory
extends SerializerFactory {
    public static final BeanSerializerFactory instance = new BeanSerializerFactory();

    protected BeanSerializerFactory() {
    }

    @Override
    public <T> JsonSerializer<T> createSerializer(Class<T> type) {
        StdSerializerFactory stdF = StdSerializerFactory.instance;
        JsonSerializer<Object> ser = stdF.findSerializerByLookup(type);
        if (ser == null && (ser = stdF.findSerializerByPrimaryType(type)) == null && (ser = this.findBeanSerializer(type)) == null) {
            ser = stdF.findSerializerByAddonType(type);
        }
        return ser;
    }

    public JsonSerializer<Object> findBeanSerializer(Class<?> type) {
        JsonSerializer<Object> ser = this.findSerializerByAnnotation(type);
        if (ser != null) {
            return ser;
        }
        if (!this.isPotentialBeanType(type)) {
            return null;
        }
        Collection<WritableBeanProperty> props = this.findBeanProperties(type);
        if (props == null || props.size() == 0) {
            return null;
        }
        return new BeanSerializer(type, props);
    }

    protected JsonSerializer<Object> findSerializerByAnnotation(AnnotatedElement elem) {
        JsonUseSerializer ann = elem.getAnnotation(JsonUseSerializer.class);
        if (ann != null) {
            Class serClass = ann.value();
            if (!JsonSerializer.class.isAssignableFrom(serClass)) {
                throw new IllegalArgumentException("Invalid @JsonSerializer annotation for " + ClassUtil.descFor(elem) + ": value (" + serClass.getName() + ") does not implement JsonSerializer interface");
            }
            try {
                Object ob = serClass.newInstance();
                JsonSerializer ser = (JsonSerializer)ob;
                return ser;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to instantiate " + serClass.getName() + " to use as serializer for " + ClassUtil.descFor(elem) + ", problem: " + e.getMessage(), e);
            }
        }
        return null;
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        return ClassUtil.canBeABeanType(type) == null && !ClassUtil.isProxyType(type);
    }

    protected Collection<WritableBeanProperty> findBeanProperties(Class<?> forClass) {
        ClassIntrospector intr = new ClassIntrospector(forClass);
        LinkedHashMap<String, Method> methodsByProp = intr.findGetters();
        if (methodsByProp.isEmpty()) {
            return null;
        }
        ArrayList<WritableBeanProperty> props = new ArrayList<WritableBeanProperty>(methodsByProp.size());
        for (Map.Entry<String, Method> en : methodsByProp.entrySet()) {
            Method m = en.getValue();
            ClassUtil.checkAndFixAccess(m, m.getDeclaringClass());
            WritableBeanProperty wprop = new WritableBeanProperty(en.getKey(), m);
            props.add(wprop);
            JsonSerializer<Object> ser = this.findSerializerByAnnotation(m);
            if (ser == null) continue;
            wprop.assignSerializer(ser);
        }
        return props;
    }
}

