/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormatHolder {
    static final String DATE_FORMAT_STR_STD = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    static final String DATE_FORMAT_STR_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    static final SimpleDateFormat DATE_FORMAT_STD = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    static final SimpleDateFormat DATE_FORMAT_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    DateFormat _formatStd;
    DateFormat _formatRfc1123;

    public Date parse(String dateStr) throws IllegalArgumentException {
        dateStr = dateStr.trim();
        DateFormat fmt = this.findLikeliestFormat(dateStr);
        try {
            return fmt.parse(dateStr);
        }
        catch (ParseException pex) {
            throw new IllegalArgumentException(String.format("Can not parse date \"%s\": not compatible with any of standard forms (\"%s\" or \"%s\")", dateStr, DATE_FORMAT_STR_STD, DATE_FORMAT_STR_RFC1123), pex);
        }
    }

    protected DateFormat findLikeliestFormat(String dateStr) {
        if (dateStr.length() >= 5 && Character.isDigit(dateStr.charAt(0)) && Character.isDigit(dateStr.charAt(3)) && dateStr.charAt(4) == '-') {
            if (this._formatStd == null) {
                this._formatStd = (DateFormat)DATE_FORMAT_STD.clone();
            }
            return this._formatStd;
        }
        if (this._formatRfc1123 == null) {
            this._formatRfc1123 = (DateFormat)DATE_FORMAT_RFC1123.clone();
        }
        return this._formatRfc1123;
    }
}

