/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.node;

import java.io.IOException;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.io.NumberOutput;
import org.codehaus.jackson.map.node.NumericNode;

public final class DoubleNode
extends NumericNode {
    final double mValue;

    public DoubleNode(double v) {
        this.mValue = v;
    }

    public static DoubleNode valueOf(double v) {
        return new DoubleNode(v);
    }

    public boolean isFloatingPointNumber() {
        return true;
    }

    public boolean isDouble() {
        return true;
    }

    public Number getNumberValue() {
        return this.mValue;
    }

    public int getIntValue() {
        return (int)this.mValue;
    }

    public long getLongValue() {
        return (long)this.mValue;
    }

    public double getDoubleValue() {
        return this.mValue;
    }

    public BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this.mValue);
    }

    public String getValueAsText() {
        return NumberOutput.toString((double)this.mValue);
    }

    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeNumber(this.mValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((DoubleNode)o).mValue == this.mValue;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.mValue);
        return (int)l ^ (int)(l >> 32);
    }
}

