/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.io.BaseReader;
import org.codehaus.jackson.io.IOContext;

public final class UTF8Reader
extends BaseReader {
    char mSurrogate = '\u0000';
    int mCharCount = 0;
    int mByteCount = 0;

    public UTF8Reader(IOContext ctxt, InputStream in, byte[] buf, int ptr, int len) {
        super(ctxt, in, buf, ptr, len);
    }

    /*
     * Unable to fully structure code
     */
    public int read(char[] cbuf, int start, int len) throws IOException {
        if (this.mBuffer == null) {
            return -1;
        }
        if (len < 1) {
            return len;
        }
        if (start < 0 || start + len > cbuf.length) {
            this.reportBounds(cbuf, start, len);
        }
        len += start;
        outPtr = start;
        if (this.mSurrogate != '\u0000') {
            cbuf[outPtr++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            left = this.mLength - this.mPtr;
            if (!(left >= 4 || left >= 1 && this.mBuffer[this.mPtr] >= 0 || this.loadMore(left))) {
                return -1;
            }
        }
        buf = this.mBuffer;
        inPtr = this.mPtr;
        inBufLen = this.mLength;
        block0: while (outPtr < len) {
            if ((c = buf[inPtr++]) < 0) ** GOTO lbl29
            cbuf[outPtr++] = (char)c;
            inMax = inBufLen - inPtr;
            outMax = len - outPtr;
            inEnd = inPtr + (inMax < outMax ? inMax : outMax);
            while (inPtr < inEnd) {
                if ((c = buf[inPtr++]) >= 0) {
                    cbuf[outPtr++] = (char)c;
                    continue;
                }
lbl29:
                // 3 sources

                if ((c & 224) == 192) {
                    c &= 31;
                    needed = 1;
                } else if ((c & 240) == 224) {
                    c &= 15;
                    needed = 2;
                } else if ((c & 248) == 240) {
                    c &= 15;
                    needed = 3;
                } else {
                    this.reportInvalidInitial(c & 255, outPtr - start);
                    needed = 1;
                }
                if (inBufLen - inPtr < needed) {
                    --inPtr;
                    break block0;
                }
                if (((d = buf[inPtr++]) & 192) != 128) {
                    this.reportInvalidOther(d & 255, outPtr - start);
                }
                c = c << 6 | d & 63;
                if (needed > 1) {
                    if (((d = buf[inPtr++]) & 192) != 128) {
                        this.reportInvalidOther(d & 255, outPtr - start);
                    }
                    c = c << 6 | d & 63;
                    if (needed > 2) {
                        if (((d = buf[inPtr++]) & 192) != 128) {
                            this.reportInvalidOther(d & 255, outPtr - start);
                        }
                        if ((c = c << 6 | d & 63) > 0x10FFFF) {
                            this.reportInvalid(c, outPtr - start, "(above " + Integer.toHexString(0x10FFFF));
                        }
                        cbuf[outPtr++] = (char)(55296 + ((c -= 65536) >> 10));
                        c = 56320 | c & 1023;
                        if (outPtr >= len) {
                            this.mSurrogate = (char)c;
                            break block0;
                        }
                    }
                }
                cbuf[outPtr++] = (char)c;
                if (inPtr < inBufLen) continue block0;
                break block0;
            }
            break block0;
        }
        this.mPtr = inPtr;
        len = outPtr - start;
        this.mCharCount += len;
        return len;
    }

    private void reportInvalidInitial(int mask, int offset) throws IOException {
        int bytePos = this.mByteCount + this.mPtr - 1;
        int charPos = this.mCharCount + offset + 1;
        throw new CharConversionException("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask) + " (at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportInvalidOther(int mask, int offset) throws IOException {
        int bytePos = this.mByteCount + this.mPtr - 1;
        int charPos = this.mCharCount + offset;
        throw new CharConversionException("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask) + " (at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportUnexpectedEOF(int gotBytes, int needed) throws IOException {
        int bytePos = this.mByteCount + gotBytes;
        int charPos = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a multi-byte char: got " + gotBytes + ", needed " + needed + ", at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportInvalid(int value, int offset, String msg) throws IOException {
        int bytePos = this.mByteCount + this.mPtr - 1;
        int charPos = this.mCharCount + offset;
        throw new CharConversionException("Invalid UTF-8 character 0x" + Integer.toHexString(value) + msg + " at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private boolean loadMore(int available) throws IOException {
        int needed;
        this.mByteCount += this.mLength - available;
        if (available > 0) {
            if (this.mPtr > 0) {
                for (int i = 0; i < available; ++i) {
                    this.mBuffer[i] = this.mBuffer[this.mPtr + i];
                }
                this.mPtr = 0;
            }
            this.mLength = available;
        } else {
            this.mPtr = 0;
            int count = this.mIn.read(this.mBuffer);
            if (count < 1) {
                this.mLength = 0;
                if (count < 0) {
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
            this.mLength = count;
        }
        byte c = this.mBuffer[0];
        if (c >= 0) {
            return true;
        }
        if ((c & 0xE0) == 192) {
            needed = 2;
        } else if ((c & 0xF0) == 224) {
            needed = 3;
        } else if ((c & 0xF8) == 240) {
            needed = 4;
        } else {
            this.reportInvalidInitial(c & 0xFF, 0);
            needed = 1;
        }
        while (this.mLength < needed) {
            int count = this.mIn.read(this.mBuffer, this.mLength, this.mBuffer.length - this.mLength);
            if (count < 1) {
                if (count < 0) {
                    this.freeBuffers();
                    this.reportUnexpectedEOF(this.mLength, needed);
                }
                this.reportStrangeStream();
            }
            this.mLength += count;
        }
        return true;
    }
}

