/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.io;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.io.IOContext;

public final class MergedStream
extends InputStream {
    protected final IOContext mContext;
    final InputStream mIn;
    byte[] mBuffer;
    int mPtr;
    final int mEnd;

    public MergedStream(IOContext context, InputStream in, byte[] buf, int start, int end) {
        this.mContext = context;
        this.mIn = in;
        this.mBuffer = buf;
        this.mPtr = start;
        this.mEnd = end;
    }

    public int available() throws IOException {
        if (this.mBuffer != null) {
            return this.mEnd - this.mPtr;
        }
        return this.mIn.available();
    }

    public void close() throws IOException {
        this.freeMergedBuffer();
        this.mIn.close();
    }

    public void mark(int readlimit) {
        if (this.mBuffer == null) {
            this.mIn.mark(readlimit);
        }
    }

    public boolean markSupported() {
        return this.mBuffer == null && this.mIn.markSupported();
    }

    public int read() throws IOException {
        if (this.mBuffer != null) {
            int c = this.mBuffer[this.mPtr++] & 0xFF;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return c;
        }
        return this.mIn.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.mBuffer != null) {
            int avail = this.mEnd - this.mPtr;
            if (len > avail) {
                len = avail;
            }
            System.arraycopy(this.mBuffer, this.mPtr, b, off, len);
            this.mPtr += len;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return len;
        }
        return this.mIn.read(b, off, len);
    }

    public void reset() throws IOException {
        if (this.mBuffer == null) {
            this.mIn.reset();
        }
    }

    public long skip(long n) throws IOException {
        long count = 0L;
        if (this.mBuffer != null) {
            int amount = this.mEnd - this.mPtr;
            if ((long)amount > n) {
                this.mPtr += (int)n;
                return amount;
            }
            this.freeMergedBuffer();
            count += (long)amount;
            n -= (long)amount;
        }
        if (n > 0L) {
            count += this.mIn.skip(n);
        }
        return count;
    }

    private void freeMergedBuffer() {
        byte[] buf = this.mBuffer;
        if (buf != null) {
            this.mBuffer = null;
            this.mContext.releaseReadIOBuffer(buf);
        }
    }
}

