/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.impl.JsonNumericParserBase;
import org.codehaus.jackson.io.IOContext;

public abstract class StreamBasedParserBase
extends JsonNumericParserBase {
    protected InputStream mInputStream;
    protected byte[] mInputBuffer;
    protected boolean mBufferRecyclable;

    protected StreamBasedParserBase(IOContext ctxt, InputStream in, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(ctxt);
        this.mInputStream = in;
        this.mInputBuffer = inputBuffer;
        this.mInputPtr = start;
        this.mInputLast = end;
        this.mBufferRecyclable = bufferRecyclable;
    }

    protected final boolean loadMore() throws IOException {
        this.mCurrInputProcessed += (long)this.mInputLast;
        this.mCurrInputRowStart -= this.mInputLast;
        if (this.mInputStream != null) {
            int count = this.mInputStream.read(this.mInputBuffer, 0, this.mInputBuffer.length);
            if (count > 0) {
                this.mInputPtr = 0;
                this.mInputLast = count;
                return true;
            }
            this.closeInput();
            if (count == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this.mInputLast);
            }
        }
        return false;
    }

    protected void closeInput() throws IOException {
        InputStream in = this.mInputStream;
        if (in != null) {
            this.mInputStream = null;
            in.close();
        }
    }

    protected void releaseBuffers() throws IOException {
        byte[] buf;
        super.releaseBuffers();
        if (this.mBufferRecyclable && (buf = this.mInputBuffer) != null) {
            this.mInputBuffer = null;
            this.mIOContext.releaseReadIOBuffer(buf);
        }
    }
}

