/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.impl.ReaderBasedNumericParser;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.util.CharTypes;
import org.codehaus.jackson.util.SymbolTable;
import org.codehaus.jackson.util.TextBuffer;

public final class ReaderBasedParser
extends ReaderBasedNumericParser {
    protected final SymbolTable mSymbols;

    public ReaderBasedParser(IOContext ioCtxt, Reader r, SymbolTable st) {
        super(ioCtxt, r);
        this.mSymbols = st;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        char i;
        if (this.mTokenIncomplete) {
            this.mTokenIncomplete = false;
            this.skipString();
        }
        while (true) {
            if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                this.handleEOF();
                this.mCurrToken = null;
                return null;
            }
            if ((i = this.mInputBuffer[this.mInputPtr++]) > ' ') break;
            if (i == ' ') continue;
            if (i == '\n') {
                this.skipLF();
                continue;
            }
            if (i == '\r') {
                this.skipCR();
                continue;
            }
            if (i == '\t') continue;
            this.throwInvalidSpace(i);
        }
        this.mTokenInputTotal = this.mCurrInputProcessed + (long)this.mInputPtr - 1L;
        this.mTokenInputRow = this.mCurrInputRow;
        this.mTokenInputCol = this.mInputPtr - this.mCurrInputRowStart - 1;
        if (i == ']') {
            if (!this.mParsingContext.isArray()) {
                this.reportMismatchedEndMarker(i, ']');
            }
            this.mParsingContext = this.mParsingContext.getParent();
            this.mCurrToken = JsonToken.END_ARRAY;
            return this.mCurrToken;
        }
        if (i == '}') {
            if (!this.mParsingContext.isObject()) {
                this.reportMismatchedEndMarker(i, '}');
            }
            this.mParsingContext = this.mParsingContext.getParent();
            this.mCurrToken = JsonToken.END_OBJECT;
            return this.mCurrToken;
        }
        int sep = this.mParsingContext.handleSeparator(i);
        switch (sep) {
            case 0: 
            case 1: {
                while (true) {
                    if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                        this.reportError("Unexpected end-of-input within/between " + this.mParsingContext.getTypeDesc() + " entries");
                    }
                    if ((i = this.mInputBuffer[this.mInputPtr++]) > ' ') break;
                    if (i == ' ') continue;
                    if (i == '\n') {
                        this.skipLF();
                        continue;
                    }
                    if (i == '\r') {
                        this.skipCR();
                        continue;
                    }
                    if (i == '\t') continue;
                    this.throwInvalidSpace(i);
                }
                if (sep != 0) break;
                return this.handleFieldName(i);
            }
            case 2: {
                this.reportUnexpectedChar(i, "was expecting comma to separate " + this.mParsingContext.getTypeDesc() + " entries");
            }
            case 3: {
                this.reportUnexpectedChar(i, "was expecting colon to separate field name and value");
            }
            case 4: {
                break;
            }
            case 5: {
                return this.handleFieldName(i);
            }
        }
        switch (i) {
            case '\"': {
                return this.startString();
            }
            case '[': {
                this.mParsingContext = this.mParsingContext.createChildArrayContext(this.mTokenInputRow, this.mTokenInputCol);
                this.mCurrToken = JsonToken.START_ARRAY;
                return this.mCurrToken;
            }
            case '{': {
                this.mParsingContext = this.mParsingContext.createChildObjectContext(this.mTokenInputRow, this.mTokenInputCol);
                this.mCurrToken = JsonToken.START_OBJECT;
                return this.mCurrToken;
            }
            case ']': 
            case '}': {
                this.reportUnexpectedChar(i, "expected a value");
            }
            case 't': {
                return this.matchToken(JsonToken.VALUE_TRUE);
            }
            case 'f': {
                return this.matchToken(JsonToken.VALUE_FALSE);
            }
            case 'n': {
                return this.matchToken(JsonToken.VALUE_NULL);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumberText(i);
            }
        }
        this.reportUnexpectedChar(i, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    public void close() throws IOException {
        super.close();
        this.mSymbols.release();
    }

    public int readBinaryValue(OutputStream results) throws IOException, JsonParseException {
        return -1;
    }

    protected JsonToken handleFieldName(int i) throws IOException, JsonParseException {
        if (i != 34) {
            this.reportUnexpectedChar(i, "was expecting double-quote to start field name");
        }
        this.mFieldInBuffer = false;
        int ptr = this.mInputPtr;
        int hash = 0;
        int inputLen = this.mInputLast;
        if (ptr < inputLen) {
            int[] codes = CharTypes.getInputCode();
            int maxCode = codes.length;
            do {
                char ch;
                if ((ch = this.mInputBuffer[ptr]) < maxCode && codes[ch] != 0) {
                    if (ch != '\"') break;
                    int start = this.mInputPtr;
                    this.mInputPtr = ptr + 1;
                    String name = this.mSymbols.findSymbol(this.mInputBuffer, start, ptr - start, hash);
                    this.mParsingContext.setCurrentName(name);
                    this.mCurrToken = JsonToken.FIELD_NAME;
                    return this.mCurrToken;
                }
                hash = hash * 31 + ch;
            } while (++ptr < inputLen);
        }
        int start = this.mInputPtr;
        this.mInputPtr = ptr;
        return this.handleFieldName2(start, hash);
    }

    private JsonToken handleFieldName2(int startPtr, int hash) throws IOException, JsonParseException {
        this.mTextBuffer.resetWithShared(this.mInputBuffer, startPtr, this.mInputPtr - startPtr);
        char[] outBuf = this.mTextBuffer.getCurrentSegment();
        int outPtr = this.mTextBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char i;
            if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                this.reportInvalidEOF(": was expecting closing quote for name");
            }
            if ((i = (c = this.mInputBuffer[this.mInputPtr++])) <= '\\') {
                if (i == '\\') {
                    c = this.decodeEscaped();
                } else if (i <= '\"') {
                    if (i == '\"') break;
                    if (i < ' ') {
                        this.throwUnquotedSpace(i, "name");
                    }
                }
            }
            hash = hash * 31 + i;
            outBuf[outPtr++] = c;
            if (outPtr < outBuf.length) continue;
            outBuf = this.mTextBuffer.finishCurrentSegment();
            outPtr = 0;
        }
        this.mTextBuffer.setCurrentLength(outPtr);
        this.mFieldInBuffer = true;
        TextBuffer tb = this.mTextBuffer;
        char[] buf = tb.getTextBuffer();
        int start = tb.getTextOffset();
        int len = tb.size();
        this.mParsingContext.setCurrentName(this.mSymbols.findSymbol(buf, start, len, hash));
        this.mCurrToken = JsonToken.FIELD_NAME;
        return this.mCurrToken;
    }

    protected JsonToken startString() throws IOException, JsonParseException {
        int ptr = this.mInputPtr;
        int inputLen = this.mInputLast;
        if (ptr < inputLen) {
            int[] codes = CharTypes.getInputCode();
            int maxCode = codes.length;
            do {
                char ch;
                if ((ch = this.mInputBuffer[ptr]) >= maxCode || codes[ch] == 0) continue;
                if (ch != '\"') break;
                this.mTextBuffer.resetWithShared(this.mInputBuffer, this.mInputPtr, ptr - this.mInputPtr);
                this.mInputPtr = ptr + 1;
                this.mCurrToken = JsonToken.VALUE_STRING;
                return this.mCurrToken;
            } while (++ptr < inputLen);
        }
        this.mTextBuffer.resetWithShared(this.mInputBuffer, this.mInputPtr, ptr - this.mInputPtr);
        this.mInputPtr = ptr;
        this.mTokenIncomplete = true;
        this.mCurrToken = JsonToken.VALUE_STRING;
        return this.mCurrToken;
    }

    protected void finishString() throws IOException, JsonParseException {
        char[] outBuf = this.mTextBuffer.getCurrentSegment();
        int outPtr = this.mTextBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char i;
            if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                this.reportInvalidEOF(": was expecting closing quote for a string value");
            }
            if ((i = (c = this.mInputBuffer[this.mInputPtr++])) <= '\\') {
                if (i == '\\') {
                    c = this.decodeEscaped();
                } else if (i <= '\"') {
                    if (i == '\"') break;
                    if (i < ' ') {
                        this.throwUnquotedSpace(i, "string value");
                    }
                }
            }
            if (outPtr >= outBuf.length) {
                outBuf = this.mTextBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = c;
        }
        this.mTextBuffer.setCurrentLength(outPtr);
    }

    protected void skipString() throws IOException, JsonParseException {
        int inputPtr = this.mInputPtr;
        int inputLen = this.mInputLast;
        char[] inputBuffer = this.mInputBuffer;
        while (true) {
            char c;
            char i;
            if (inputPtr >= inputLen) {
                this.mInputPtr = inputPtr;
                if (!this.loadMore()) {
                    this.reportInvalidEOF(": was expecting closing quote for a string value");
                }
                inputPtr = this.mInputPtr;
                inputLen = this.mInputLast;
            }
            if ((i = (c = inputBuffer[inputPtr++])) > '\\') continue;
            if (i == '\\') {
                this.mInputPtr = inputPtr;
                c = this.decodeEscaped();
                inputPtr = this.mInputPtr;
                inputLen = this.mInputLast;
                continue;
            }
            if (i > '\"') continue;
            if (i == '\"') break;
            if (i >= ' ') continue;
            this.mInputPtr = inputPtr;
            this.throwUnquotedSpace(i, "string value");
        }
        this.mInputPtr = inputPtr;
    }

    protected JsonToken matchToken(JsonToken token) throws IOException, JsonParseException {
        String matchStr = token.asString();
        int len = matchStr.length();
        for (int i = 1; i < len; ++i) {
            char c;
            if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                this.reportInvalidEOF(" in a value");
            }
            if ((c = this.mInputBuffer[this.mInputPtr]) != matchStr.charAt(i)) {
                this.reportInvalidToken(matchStr.substring(0, i));
            }
            ++this.mInputPtr;
        }
        this.mCurrToken = token;
        return this.mCurrToken;
    }

    private void reportInvalidToken(String matchedPart) throws IOException, JsonParseException {
        char c;
        StringBuilder sb = new StringBuilder(matchedPart);
        while ((this.mInputPtr < this.mInputLast || this.loadMore()) && Character.isJavaIdentifierPart(c = this.mInputBuffer[this.mInputPtr])) {
            ++this.mInputPtr;
            sb.append(c);
        }
        this.reportError("Unrecognized token '" + sb.toString() + "': was expecting 'null', 'true' or 'false'");
    }

    protected final char decodeEscaped() throws IOException, JsonParseException {
        if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
            this.reportInvalidEOF(" in character escape sequence");
        }
        char c = this.mInputBuffer[this.mInputPtr++];
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '/': 
            case '\\': {
                return c;
            }
            case 'u': {
                break;
            }
            default: {
                this.reportError("Unrecognized character escape " + ReaderBasedParser.getCharDesc(c));
            }
        }
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            char ch;
            int digit;
            if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                this.reportInvalidEOF(" in character escape sequence");
            }
            if ((digit = CharTypes.charToHex(ch = this.mInputBuffer[this.mInputPtr++])) < 0) {
                this.reportUnexpectedChar(ch, "expected a hex-digit for character escape sequence");
            }
            value = value << 4 | digit;
        }
        return (char)value;
    }
}

