/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.impl.JsonParserBase;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.NumberInput;

public abstract class JsonNumericParserBase
extends JsonParserBase {
    protected static final int NR_UNKNOWN = 0;
    protected static final int NR_INT = 1;
    protected static final int NR_LONG = 2;
    protected static final int NR_BIGINT = 4;
    protected static final int NR_DOUBLE = 8;
    protected static final int NR_BIGDECIMAL = 16;
    static final BigDecimal BD_MIN_LONG = new BigDecimal(Long.MIN_VALUE);
    static final BigDecimal BD_MAX_LONG = new BigDecimal(Long.MAX_VALUE);
    static final BigDecimal BD_MIN_INT = new BigDecimal(Long.MIN_VALUE);
    static final BigDecimal BD_MAX_INT = new BigDecimal(Long.MAX_VALUE);
    static double MIN_LONG_D = -9.223372036854776E18;
    static double MAX_LONG_D = 9.223372036854776E18;
    static double MIN_INT_D = -2.147483648E9;
    static double MAX_INT_D = 2.147483647E9;
    protected static final int INT_0 = 48;
    protected static final int INT_1 = 49;
    protected static final int INT_2 = 50;
    protected static final int INT_3 = 51;
    protected static final int INT_4 = 52;
    protected static final int INT_5 = 53;
    protected static final int INT_6 = 54;
    protected static final int INT_7 = 55;
    protected static final int INT_8 = 56;
    protected static final int INT_9 = 57;
    protected static final int INT_MINUS = 45;
    protected static final int INT_PLUS = 45;
    protected static final int INT_DECIMAL_POINT = 46;
    protected static final int INT_e = 101;
    protected static final int INT_E = 69;
    protected static final char CHAR_NULL = '\u0000';
    protected int mNumTypesValid = 0;
    protected int mNumberInt;
    protected long mNumberLong;
    protected double mNumberDouble;
    protected BigInteger mNumberBigInt;
    protected BigDecimal mNumberBigDecimal;
    protected boolean mNumberNegative;
    protected int mIntLength;
    protected int mFractLength;
    protected int mExpLength;

    protected JsonNumericParserBase(IOContext ctxt) {
        super(ctxt);
    }

    protected final JsonToken reset(boolean negative, int intLen, int fractLen, int expLen) {
        this.mNumberNegative = negative;
        this.mIntLength = intLen;
        this.mFractLength = fractLen;
        this.mExpLength = expLen;
        this.mNumTypesValid = 0;
        if (fractLen < 1 && expLen < 1) {
            this.mCurrToken = JsonToken.VALUE_NUMBER_INT;
            return this.mCurrToken;
        }
        this.mCurrToken = JsonToken.VALUE_NUMBER_FLOAT;
        return this.mCurrToken;
    }

    protected abstract JsonToken parseNumberText(int var1) throws IOException, JsonParseException;

    public Number getNumberValue() throws IOException, JsonParseException {
        if (this.mNumTypesValid == 0) {
            this.parseNumericValue(0);
        }
        if (this.mCurrToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this.mNumTypesValid & 1) != 0) {
                return this.mNumberInt;
            }
            if ((this.mNumTypesValid & 2) != 0) {
                return this.mNumberLong;
            }
            if ((this.mNumTypesValid & 4) != 0) {
                return this.mNumberBigInt;
            }
            return this.mNumberBigDecimal;
        }
        if ((this.mNumTypesValid & 0x10) != 0) {
            return this.mNumberBigDecimal;
        }
        if ((this.mNumTypesValid & 8) == 0) {
            this.throwInternal();
        }
        return this.mNumberDouble;
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        if (this.mNumTypesValid == 0) {
            this.parseNumericValue(0);
        }
        if (this.mCurrToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this.mNumTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((this.mNumTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if ((this.mNumTypesValid & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        return JsonParser.NumberType.DOUBLE;
    }

    public int getIntValue() throws IOException, JsonParseException {
        if ((this.mNumTypesValid & 1) == 0) {
            if (this.mNumTypesValid == 0) {
                this.parseNumericValue(1);
            }
            if ((this.mNumTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this.mNumberInt;
    }

    public long getLongValue() throws IOException, JsonParseException {
        if ((this.mNumTypesValid & 2) == 0) {
            if (this.mNumTypesValid == 0) {
                this.parseNumericValue(2);
            }
            if ((this.mNumTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this.mNumberLong;
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        if ((this.mNumTypesValid & 8) == 0) {
            if (this.mNumTypesValid == 0) {
                this.parseNumericValue(8);
            }
            if ((this.mNumTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this.mNumberDouble;
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        if ((this.mNumTypesValid & 0x10) == 0) {
            if (this.mNumTypesValid == 0) {
                this.parseNumericValue(16);
            }
            if ((this.mNumTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this.mNumberBigDecimal;
    }

    protected final void parseNumericValue(int expType) throws JsonParseException {
        if (this.mCurrToken == null || !this.mCurrToken.isNumeric()) {
            this.reportError("Current token (" + (Object)((Object)this.mCurrToken) + ") not numeric, can not use numeric value accessors");
        }
        try {
            if (this.mCurrToken == JsonToken.VALUE_NUMBER_INT) {
                char[] buf = this.mTextBuffer.getTextBuffer();
                int offset = this.mTextBuffer.getTextOffset();
                if (this.mNumberNegative) {
                    ++offset;
                }
                if (this.mIntLength <= 9) {
                    int i = NumberInput.parseInt(buf, offset, this.mIntLength);
                    this.mNumberInt = this.mNumberNegative ? -i : i;
                    this.mNumTypesValid = 1;
                    return;
                }
                if (this.mIntLength <= 18) {
                    long l = NumberInput.parseLong(buf, offset, this.mIntLength);
                    this.mNumberLong = this.mNumberNegative ? -l : l;
                    this.mNumTypesValid = 2;
                    return;
                }
                BigInteger bi = new BigInteger(this.mTextBuffer.contentsAsString());
                this.mNumberBigDecimal = new BigDecimal(bi);
                this.mNumTypesValid = 16;
                return;
            }
            if (expType == 16) {
                this.mNumberBigDecimal = this.mTextBuffer.contentsAsDecimal();
                this.mNumTypesValid = 16;
            } else {
                this.mNumberDouble = this.mTextBuffer.contentsAsDouble();
                this.mNumTypesValid = 8;
            }
        }
        catch (NumberFormatException nex) {
            this.wrapError("Malformed numeric value '" + this.mTextBuffer.contentsAsString() + "'", nex);
        }
    }

    protected void convertNumberToInt() throws IOException, JsonParseException {
        if ((this.mNumTypesValid & 2) != 0) {
            int result = (int)this.mNumberLong;
            if ((long)result != this.mNumberLong) {
                this.reportError("Numeric value (" + this.getText() + ") out of range of int");
            }
            this.mNumberInt = result;
        } else if ((this.mNumTypesValid & 8) != 0) {
            if (this.mNumberDouble < MIN_INT_D || this.mNumberDouble > MAX_INT_D) {
                this.reportOverflowInt();
            }
            this.mNumberInt = (int)this.mNumberDouble;
        } else if ((this.mNumTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this.mNumberBigDecimal) > 0 || BD_MAX_INT.compareTo(this.mNumberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this.mNumberInt = this.mNumberBigDecimal.intValue();
        } else {
            this.throwInternal();
        }
        this.mNumTypesValid |= 1;
    }

    protected void convertNumberToLong() throws IOException, JsonParseException {
        if ((this.mNumTypesValid & 1) != 0) {
            this.mNumberLong = this.mNumberInt;
        } else if ((this.mNumTypesValid & 8) != 0) {
            if (this.mNumberDouble < MIN_LONG_D || this.mNumberDouble > MAX_LONG_D) {
                this.reportOverflowLong();
            }
            this.mNumberLong = (long)this.mNumberDouble;
        } else if ((this.mNumTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this.mNumberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this.mNumberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this.mNumberLong = this.mNumberBigDecimal.longValue();
        } else {
            this.throwInternal();
        }
        this.mNumTypesValid |= 2;
    }

    protected void convertNumberToDouble() throws IOException, JsonParseException {
        if ((this.mNumTypesValid & 0x10) != 0) {
            this.mNumberDouble = this.mNumberBigDecimal.doubleValue();
        } else if ((this.mNumTypesValid & 2) != 0) {
            this.mNumberDouble = this.mNumberLong;
        } else if ((this.mNumTypesValid & 1) != 0) {
            this.mNumberDouble = this.mNumberInt;
        } else {
            this.throwInternal();
        }
        this.mNumTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() throws IOException, JsonParseException {
        if ((this.mNumTypesValid & 8) != 0) {
            this.mNumberBigDecimal = new BigDecimal(this.getText());
        } else if ((this.mNumTypesValid & 2) != 0) {
            this.mNumberBigDecimal = BigDecimal.valueOf(this.mNumberLong);
        } else if ((this.mNumTypesValid & 1) != 0) {
            this.mNumberBigDecimal = BigDecimal.valueOf(this.mNumberInt);
        } else {
            this.throwInternal();
        }
        this.mNumTypesValid |= 0x10;
    }

    protected void reportUnexpectedNumberChar(int ch, String comment) throws JsonParseException {
        String msg = "Unexpected character (" + JsonNumericParserBase.getCharDesc(ch) + ") in numeric value";
        if (comment != null) {
            msg = msg + ": " + comment;
        }
        this.reportError(msg);
    }

    protected void reportInvalidNumber(String msg) throws JsonParseException {
        this.reportError("Invalid numeric value: " + msg);
    }

    protected void reportOverflowInt() throws IOException, JsonParseException {
        this.reportError("Numeric value (" + this.getText() + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
    }

    protected void reportOverflowLong() throws IOException, JsonParseException {
        this.reportError("Numeric value (" + this.getText() + ") out of range of long (" + Long.MIN_VALUE + " - " + Long.MAX_VALUE + ")");
    }
}

