/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonNode;
import org.codehaus.jackson.map.impl.ContainerNode;
import org.codehaus.jackson.map.impl.MissingNode;
import org.codehaus.jackson.map.impl.TextNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectNode
extends ContainerNode {
    LinkedHashMap<String, JsonNode> mChildren = null;

    protected ObjectNode() {
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public int size() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    @Override
    public JsonNode getElementValue(int index) {
        return null;
    }

    @Override
    public JsonNode getFieldValue(String fieldName) {
        if (this.mChildren != null) {
            return this.mChildren.get(fieldName);
        }
        return null;
    }

    @Override
    public Iterator<String> getFieldNames() {
        return this.mChildren == null ? ContainerNode.NoStringsIterator.instance() : this.mChildren.keySet().iterator();
    }

    @Override
    public Iterator<JsonNode> getFieldValues() {
        return this.mChildren == null ? ContainerNode.NoNodesIterator.instance() : this.mChildren.values().iterator();
    }

    @Override
    public JsonNode getPath(int index) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode getPath(String fieldName) {
        JsonNode n;
        if (this.mChildren != null && (n = this.mChildren.get(fieldName)) != null) {
            return n;
        }
        return MissingNode.getInstance();
    }

    @Override
    public void appendElement(JsonNode node) {
        this.reportNoArrayMods();
    }

    @Override
    public void insertElement(int index, JsonNode value) {
        this.reportNoArrayMods();
    }

    @Override
    public JsonNode removeElement(int index) {
        return this.reportNoArrayMods();
    }

    @Override
    public JsonNode removeElement(String fieldName) {
        if (this.mChildren != null) {
            return (JsonNode)this.mChildren.remove(fieldName);
        }
        return null;
    }

    @Override
    public JsonNode setElement(int index, JsonNode value) {
        return this.reportNoArrayMods();
    }

    @Override
    public JsonNode setElement(String fieldName, JsonNode value) {
        if (this.mChildren == null) {
            this.mChildren = new LinkedHashMap();
        }
        return this.mChildren.put(fieldName, value);
    }

    @Override
    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeStartObject();
        if (this.mChildren != null) {
            for (Map.Entry<String, JsonNode> en : this.mChildren.entrySet()) {
                jg.writeFieldName(en.getKey());
                en.getValue().writeTo(jg);
            }
        }
        jg.writeEndObject();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ObjectNode other = (ObjectNode)o;
        if (other.size() != this.size()) {
            return false;
        }
        if (this.mChildren != null) {
            for (Map.Entry<String, JsonNode> en : this.mChildren.entrySet()) {
                String key = en.getKey();
                JsonNode value = en.getValue();
                JsonNode otherValue = other.getFieldValue(key);
                if (otherValue != null && otherValue.equals(value)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32 + (this.size() << 4));
        sb.append("{");
        if (this.mChildren != null) {
            int count = 0;
            for (Map.Entry<String, JsonNode> en : this.mChildren.entrySet()) {
                if (count > 0) {
                    sb.append(",");
                }
                ++count;
                TextNode.appendQuoted(sb, en.getKey());
                sb.append(':');
                sb.append(en.getValue().toString());
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

