/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.impl.Utf8NumericParser;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.sym.Name;
import org.codehaus.jackson.sym.NameCanonicalizer;
import org.codehaus.jackson.util.CharTypes;

public final class Utf8StreamParser
extends Utf8NumericParser {
    protected final NameCanonicalizer mSymbols;
    protected int[] mQuadBuffer = new int[32];

    public Utf8StreamParser(IOContext ctxt, InputStream in, NameCanonicalizer sym, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(ctxt, in, inputBuffer, start, end, bufferRecyclable);
        this.mSymbols = sym;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        int i;
        if (this.mTokenIncomplete) {
            this.mTokenIncomplete = false;
            this.skipString();
        }
        while (true) {
            if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                this.handleEOF();
                this.mCurrToken = null;
                return null;
            }
            if ((i = this.mInputBuffer[this.mInputPtr++] & 0xFF) > 32) break;
            if (i == 32) continue;
            if (i == 10) {
                this.skipLF();
                continue;
            }
            if (i == 13) {
                this.skipCR();
                continue;
            }
            if (i == 9) continue;
            this.throwInvalidSpace(i);
        }
        this.mTokenInputTotal = this.mCurrInputProcessed + (long)this.mInputPtr - 1L;
        this.mTokenInputRow = this.mCurrInputRow;
        this.mTokenInputCol = this.mInputPtr - this.mCurrInputRowStart - 1;
        if (i == 93) {
            if (!this.mParsingContext.isArray()) {
                this.reportMismatchedEndMarker(i, ']');
            }
            this.mParsingContext = this.mParsingContext.getParent();
            this.mCurrToken = JsonToken.END_ARRAY;
            return this.mCurrToken;
        }
        if (i == 125) {
            if (!this.mParsingContext.isObject()) {
                this.reportMismatchedEndMarker(i, '}');
            }
            this.mParsingContext = this.mParsingContext.getParent();
            this.mCurrToken = JsonToken.END_OBJECT;
            return this.mCurrToken;
        }
        int sep = this.mParsingContext.handleSeparator(i);
        switch (sep) {
            case 0: 
            case 1: {
                while (true) {
                    if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                        this.reportError("Unexpected end-of-input within/between " + this.mParsingContext.getTypeDesc() + " entries");
                    }
                    if ((i = this.mInputBuffer[this.mInputPtr++] & 0xFF) > 32) break;
                    if (i == 32) continue;
                    if (i == 10) {
                        this.skipLF();
                        continue;
                    }
                    if (i == 13) {
                        this.skipCR();
                        continue;
                    }
                    if (i == 9) continue;
                    this.throwInvalidSpace(i);
                }
                if (sep != 0) break;
                this.mParsingContext.setCurrentName(this.parseFieldName(i).getName());
                this.mCurrToken = JsonToken.FIELD_NAME;
                return this.mCurrToken;
            }
            case 2: {
                this.reportUnexpectedChar(i, "was expecting comma to separate " + this.mParsingContext.getTypeDesc() + " entries");
            }
            case 3: {
                this.reportUnexpectedChar(i, "was expecting colon to separate field name and value");
            }
            case 4: {
                break;
            }
            case 5: {
                this.mParsingContext.setCurrentName(this.parseFieldName(i).getName());
                this.mCurrToken = JsonToken.FIELD_NAME;
                return this.mCurrToken;
            }
        }
        switch (i) {
            case 34: {
                this.mTokenIncomplete = true;
                this.mCurrToken = JsonToken.VALUE_STRING;
                return this.mCurrToken;
            }
            case 91: {
                this.mParsingContext = this.mParsingContext.createChildArrayContext(this.mTokenInputRow, this.mTokenInputCol);
                this.mCurrToken = JsonToken.START_ARRAY;
                return this.mCurrToken;
            }
            case 123: {
                this.mParsingContext = this.mParsingContext.createChildObjectContext(this.mTokenInputRow, this.mTokenInputCol);
                this.mCurrToken = JsonToken.START_OBJECT;
                return this.mCurrToken;
            }
            case 93: 
            case 125: {
                this.reportUnexpectedChar(i, "expected a value");
            }
            case 116: {
                return this.matchToken(JsonToken.VALUE_TRUE);
            }
            case 102: {
                return this.matchToken(JsonToken.VALUE_FALSE);
            }
            case 110: {
                return this.matchToken(JsonToken.VALUE_NULL);
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.parseNumberText(i);
            }
        }
        this.reportUnexpectedChar(i, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    public void close() throws IOException {
        super.close();
        this.mSymbols.release();
    }

    public int readBinaryValue(OutputStream results) throws IOException, JsonParseException {
        return -1;
    }

    protected Name parseFieldName(int i) throws IOException, JsonParseException {
        int q;
        if (i != 34) {
            this.reportUnexpectedChar(i, "was expecting double-quote to start field name");
        }
        this.mFieldInBuffer = false;
        if (this.mInputLast - this.mInputPtr < 9) {
            return this.slowParseFieldName();
        }
        int[] codes = CharTypes.getInputCode();
        if (codes[q = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
            if (q == 34) {
                return NameCanonicalizer.getEmptyName();
            }
            return this.parseFieldName(0, q, 1);
        }
        if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q, 1);
            }
            return this.parseFieldName(q, i, 1);
        }
        q = q << 8 | i;
        if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q, 2);
            }
            return this.parseFieldName(q, i, 2);
        }
        q = q << 8 | i;
        if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q, 3);
            }
            return this.parseFieldName(q, i, 3);
        }
        q = q << 8 | i;
        if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q, 4);
            }
            return this.parseFieldName(q, i, 4);
        }
        return this.parseMediumFieldName(q, i);
    }

    protected Name parseMediumFieldName(int q1, int q2) throws IOException, JsonParseException {
        int i;
        int[] codes = CharTypes.getInputCode();
        if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q1, q2, 1);
            }
            return this.parseFieldName(q1, q2, i, 1);
        }
        q2 = q2 << 8 | i;
        if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q1, q2, 2);
            }
            return this.parseFieldName(q1, q2, i, 2);
        }
        q2 = q2 << 8 | i;
        if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q1, q2, 3);
            }
            return this.parseFieldName(q1, q2, i, 3);
        }
        q2 = q2 << 8 | i;
        if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q1, q2, 4);
            }
            return this.parseFieldName(q1, q2, i, 4);
        }
        this.mQuadBuffer[0] = q1;
        this.mQuadBuffer[1] = q2;
        return this.parseLongFieldName(i);
    }

    protected Name parseLongFieldName(int q) throws IOException, JsonParseException {
        int[] codes = CharTypes.getInputCode();
        int qlen = 2;
        while (this.mInputLast - this.mInputPtr >= 4) {
            int i;
            if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this.mQuadBuffer, qlen, q, 1);
                }
                return this.parseEscapedFieldName(this.mQuadBuffer, qlen, q, i, 1);
            }
            q = q << 8 | i;
            if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this.mQuadBuffer, qlen, q, 2);
                }
                return this.parseEscapedFieldName(this.mQuadBuffer, qlen, q, i, 2);
            }
            q = q << 8 | i;
            if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this.mQuadBuffer, qlen, q, 3);
                }
                return this.parseEscapedFieldName(this.mQuadBuffer, qlen, q, i, 3);
            }
            q = q << 8 | i;
            if (codes[i = this.mInputBuffer[this.mInputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this.mQuadBuffer, qlen, q, 4);
                }
                return this.parseEscapedFieldName(this.mQuadBuffer, qlen, q, i, 4);
            }
            if (qlen >= this.mQuadBuffer.length) {
                this.mQuadBuffer = Utf8StreamParser.growArrayBy(this.mQuadBuffer, qlen);
            }
            this.mQuadBuffer[qlen++] = q;
            q = i;
        }
        return this.parseEscapedFieldName(this.mQuadBuffer, qlen, 0, q, 0);
    }

    protected Name slowParseFieldName() throws IOException, JsonParseException {
        int i;
        if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
            this.reportInvalidEOF(": was expecting closing quote for name");
        }
        if ((i = this.mInputBuffer[this.mInputPtr++] & 0xFF) == 34) {
            return NameCanonicalizer.getEmptyName();
        }
        return this.parseEscapedFieldName(this.mQuadBuffer, 0, 0, i, 0);
    }

    private final Name parseFieldName(int q1, int ch, int lastQuadBytes) throws IOException, JsonParseException {
        return this.parseEscapedFieldName(this.mQuadBuffer, 0, q1, ch, lastQuadBytes);
    }

    private final Name parseFieldName(int q1, int q2, int ch, int lastQuadBytes) throws IOException, JsonParseException {
        this.mQuadBuffer[0] = q1;
        return this.parseEscapedFieldName(this.mQuadBuffer, 1, q2, ch, lastQuadBytes);
    }

    protected Name parseEscapedFieldName(int[] quads, int qlen, int currQuad, int ch, int currQuadBytes) throws IOException, JsonParseException {
        Name name;
        int[] codes = CharTypes.getInputCode();
        while (true) {
            if (codes[ch] != 0) {
                if (ch == 34) break;
                if (ch != 92) {
                    this.throwUnquotedSpace(ch, "name");
                }
                if ((ch = (int)this.decodeEscaped()) > 127) {
                    if (currQuadBytes >= 4) {
                        if (qlen >= quads.length) {
                            quads = Utf8StreamParser.growArrayBy(quads, quads.length);
                            this.mQuadBuffer = quads;
                        }
                        quads[qlen++] = currQuad;
                        currQuad = 0;
                        currQuadBytes = 0;
                    }
                    if (ch < 2048) {
                        currQuad = currQuad << 8 | (0xC0 | ch >> 6);
                        ++currQuadBytes;
                    } else {
                        currQuad = currQuad << 8 | (0xE0 | ch >> 12);
                        if (++currQuadBytes >= 4) {
                            if (qlen >= quads.length) {
                                quads = Utf8StreamParser.growArrayBy(quads, quads.length);
                                this.mQuadBuffer = quads;
                            }
                            quads[qlen++] = currQuad;
                            currQuad = 0;
                            currQuadBytes = 0;
                        }
                        currQuad = currQuad << 8 | (0x80 | ch >> 6 & 0x3F);
                        ++currQuadBytes;
                    }
                    ch = 0x80 | ch & 0x3F;
                }
            }
            if (currQuadBytes < 4) {
                ++currQuadBytes;
                currQuad = currQuad << 8 | ch;
            } else {
                if (qlen >= quads.length) {
                    quads = Utf8StreamParser.growArrayBy(quads, quads.length);
                    this.mQuadBuffer = quads;
                }
                quads[qlen++] = currQuad;
                currQuad = ch;
                currQuadBytes = 1;
            }
            if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                this.reportInvalidEOF(" in field name");
            }
            ch = this.mInputBuffer[this.mInputPtr++] & 0xFF;
        }
        if (currQuadBytes > 0) {
            if (qlen >= quads.length) {
                quads = Utf8StreamParser.growArrayBy(quads, quads.length);
                this.mQuadBuffer = quads;
            }
            quads[qlen++] = currQuad;
        }
        if ((name = this.mSymbols.findName(quads, qlen)) == null) {
            name = this.addName(quads, qlen, currQuadBytes);
        }
        return name;
    }

    private final Name findName(int q1, int lastQuadBytes) throws JsonParseException {
        Name name = this.mSymbols.findName(q1);
        if (name != null) {
            return name;
        }
        this.mQuadBuffer[0] = q1;
        return this.addName(this.mQuadBuffer, 1, lastQuadBytes);
    }

    private final Name findName(int q1, int q2, int lastQuadBytes) throws JsonParseException {
        Name name = this.mSymbols.findName(q1, q2);
        if (name != null) {
            return name;
        }
        this.mQuadBuffer[0] = q1;
        this.mQuadBuffer[1] = q2;
        return this.addName(this.mQuadBuffer, 2, lastQuadBytes);
    }

    private final Name findName(int[] quads, int qlen, int lastQuad, int lastQuadBytes) throws JsonParseException {
        if (qlen >= quads.length) {
            quads = Utf8StreamParser.growArrayBy(quads, quads.length);
            this.mQuadBuffer = quads;
        }
        quads[qlen++] = lastQuad;
        Name name = this.mSymbols.findName(quads, qlen);
        if (name == null) {
            return this.addName(quads, qlen, lastQuadBytes);
        }
        return name;
    }

    private final Name addName(int[] quads, int qlen, int lastQuadBytes) throws JsonParseException {
        int lastQuad;
        int byteLen = (qlen << 2) - 4 + lastQuadBytes;
        if (lastQuadBytes < 4) {
            lastQuad = quads[qlen - 1];
            quads[qlen - 1] = lastQuad << (4 - lastQuadBytes << 3);
        } else {
            lastQuad = 0;
        }
        char[] cbuf = this.mTextBuffer.emptyAndGetCurrentSegment();
        int cix = 0;
        int ix = 0;
        while (ix < byteLen) {
            int ch = quads[ix >> 2];
            int byteIx = ix & 3;
            ch = ch >> (3 - byteIx << 3) & 0xFF;
            ++ix;
            if (ch > 127) {
                int needed;
                if ((ch & 0xE0) == 192) {
                    ch &= 0x1F;
                    needed = 1;
                } else if ((ch & 0xF0) == 224) {
                    ch &= 0xF;
                    needed = 2;
                } else if ((ch & 0xF8) == 240) {
                    ch &= 7;
                    needed = 3;
                } else {
                    this.reportInvalidInitial(ch);
                    ch = 1;
                    needed = 1;
                }
                if (ix + needed > byteLen) {
                    this.reportInvalidEOF(" in field name");
                }
                int ch2 = quads[ix >> 2];
                byteIx = ix & 3;
                ++ix;
                if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                    this.reportInvalidOther(ch2);
                }
                ch = ch << 6 | ch2 & 0x3F;
                if (needed > 1) {
                    ch2 = quads[ix >> 2];
                    byteIx = ix & 3;
                    ++ix;
                    if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                        this.reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 2) {
                        ch2 = quads[ix >> 2];
                        byteIx = ix & 3;
                        ++ix;
                        if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                            this.reportInvalidOther(ch2 & 0xFF);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                    }
                }
                if (needed > 2) {
                    ch -= 65536;
                    if (cix >= cbuf.length) {
                        cbuf = this.mTextBuffer.expandCurrentSegment();
                    }
                    cbuf[cix++] = (char)(55296 + (ch >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                }
            }
            if (cix >= cbuf.length) {
                cbuf = this.mTextBuffer.expandCurrentSegment();
            }
            cbuf[cix++] = (char)ch;
        }
        String baseName = new String(cbuf, 0, cix);
        if (lastQuadBytes < 4) {
            quads[qlen - 1] = lastQuad;
        }
        return this.mSymbols.addName(baseName, quads, qlen);
    }

    protected void finishString() throws IOException, JsonParseException {
        int outPtr = 0;
        char[] outBuf = this.mTextBuffer.emptyAndGetCurrentSegment();
        int[] codes = CharTypes.getInputCodeUtf8();
        byte[] inputBuffer = this.mInputBuffer;
        while (true) {
            int c;
            int ptr;
            block16: {
                int max;
                int max2;
                if ((ptr = this.mInputPtr) >= this.mInputLast) {
                    this.loadMoreGuaranteed();
                    ptr = this.mInputPtr;
                }
                if (outPtr >= outBuf.length) {
                    outBuf = this.mTextBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outBuf.length - outPtr)) < (max = this.mInputLast)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (codes[c = inputBuffer[ptr++] & 0xFF] == 0) {
                        outBuf[outPtr++] = (char)c;
                        continue;
                    }
                    break block16;
                }
                this.mInputPtr = ptr;
                continue;
            }
            this.mInputPtr = ptr;
            if (c == 34) break;
            switch (codes[c]) {
                case 1: {
                    c = this.decodeEscaped();
                    break;
                }
                case 2: {
                    c = this.decodeUtf8_2(c);
                    break;
                }
                case 3: {
                    if (this.mInputLast - this.mInputPtr >= 2) {
                        c = this.decodeUtf8_3fast(c);
                        break;
                    }
                    c = this.decodeUtf8_3(c);
                    break;
                }
                case 4: {
                    c = this.decodeUtf8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this.mTextBuffer.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    if (c < 32) {
                        this.throwUnquotedSpace(c, "string value");
                    }
                    this.reportUnexpectedChar(c, null);
                }
            }
            if (outPtr >= outBuf.length) {
                outBuf = this.mTextBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = (char)c;
        }
        this.mTextBuffer.setCurrentLength(outPtr);
    }

    protected void skipString() throws IOException, JsonParseException {
        int[] codes = CharTypes.getInputCodeUtf8();
        byte[] inputBuffer = this.mInputBuffer;
        block6: while (true) {
            int c;
            int ptr;
            block10: {
                int max;
                if ((ptr = this.mInputPtr) >= (max = this.mInputLast)) {
                    this.loadMoreGuaranteed();
                    ptr = this.mInputPtr;
                    max = this.mInputLast;
                }
                while (ptr < max) {
                    if (codes[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block10;
                }
                this.mInputPtr = ptr;
                continue;
            }
            this.mInputPtr = ptr;
            if (c == 34) break;
            switch (codes[c]) {
                case 1: {
                    this.decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this.skipUtf8_2(c);
                    continue block6;
                }
                case 3: {
                    this.skipUtf8_3(c);
                    continue block6;
                }
                case 4: {
                    this.skipUtf8_4(c);
                    continue block6;
                }
            }
            if (c < 32) {
                this.throwUnquotedSpace(c, "string value");
            }
            this.reportUnexpectedChar(c, null);
        }
    }

    protected JsonToken matchToken(JsonToken token) throws IOException, JsonParseException {
        byte[] matchBytes = token.asByteArray();
        int len = matchBytes.length;
        for (int i = 1; i < len; ++i) {
            if (this.mInputPtr >= this.mInputLast) {
                this.loadMoreGuaranteed();
            }
            if (matchBytes[i] != this.mInputBuffer[this.mInputPtr]) {
                this.reportInvalidToken(token.asString().substring(0, i));
            }
            ++this.mInputPtr;
        }
        this.mCurrToken = token;
        return this.mCurrToken;
    }

    private void reportInvalidToken(String matchedPart) throws IOException, JsonParseException {
        byte i;
        char c;
        StringBuilder sb = new StringBuilder(matchedPart);
        while ((this.mInputPtr < this.mInputLast || this.loadMore()) && Character.isJavaIdentifierPart(c = (char)this.decodeCharForError(i = this.mInputBuffer[this.mInputPtr++]))) {
            ++this.mInputPtr;
            sb.append(c);
        }
        this.reportError("Unrecognized token '" + sb.toString() + "': was expecting 'null', 'true' or 'false'");
    }

    protected final char decodeEscaped() throws IOException, JsonParseException {
        if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
            this.reportInvalidEOF(" in character escape sequence");
        }
        byte c = this.mInputBuffer[this.mInputPtr++];
        switch (c) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)c;
            }
            case 117: {
                break;
            }
            default: {
                this.reportError("Unrecognized character escape \\ followed by " + Utf8StreamParser.getCharDesc(this.decodeCharForError(c)));
            }
        }
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            byte ch;
            int digit;
            if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
                this.reportInvalidEOF(" in character escape sequence");
            }
            if ((digit = CharTypes.charToHex(ch = this.mInputBuffer[this.mInputPtr++])) < 0) {
                this.reportUnexpectedChar(ch, "expected a hex-digit for character escape sequence");
            }
            value = value << 4 | digit;
        }
        return (char)value;
    }

    protected int decodeCharForError(int firstByte) throws IOException, JsonParseException {
        int c = firstByte;
        if (c < 0) {
            int needed;
            if ((c & 0xE0) == 192) {
                c &= 0x1F;
                needed = 1;
            } else if ((c & 0xF0) == 224) {
                c &= 0xF;
                needed = 2;
            } else if ((c & 0xF8) == 240) {
                c &= 7;
                needed = 3;
            } else {
                this.reportInvalidInitial(c & 0xFF);
                needed = 1;
            }
            int d = this.nextByte();
            if ((d & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF);
            }
            c = c << 6 | d & 0x3F;
            if (needed > 1) {
                d = this.nextByte();
                if ((d & 0xC0) != 128) {
                    this.reportInvalidOther(d & 0xFF);
                }
                c = c << 6 | d & 0x3F;
                if (needed > 2) {
                    d = this.nextByte();
                    if ((d & 0xC0) != 128) {
                        this.reportInvalidOther(d & 0xFF);
                    }
                    c = c << 6 | d & 0x3F;
                }
            }
        }
        return c;
    }

    private final int decodeUtf8_2(int c) throws IOException, JsonParseException {
        byte d;
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    private final int decodeUtf8_3(int c1) throws IOException, JsonParseException {
        byte d;
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        c1 &= 0xF;
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int decodeUtf8_3fast(int c1) throws IOException, JsonParseException {
        byte d;
        c1 &= 0xF;
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int decodeUtf8_4(int c) throws IOException, JsonParseException {
        byte d;
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    private final void skipUtf8_2(int c) throws IOException, JsonParseException {
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((c = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(c & 0xFF, this.mInputPtr);
        }
    }

    private final void skipUtf8_3(int c) throws IOException, JsonParseException {
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((c = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(c & 0xFF, this.mInputPtr);
        }
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((c = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(c & 0xFF, this.mInputPtr);
        }
    }

    private final void skipUtf8_4(int c) throws IOException, JsonParseException {
        byte d;
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if ((d & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        if (((d = this.mInputBuffer[this.mInputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this.mInputPtr);
        }
    }

    private int nextByte() throws IOException, JsonParseException {
        if (this.mInputPtr >= this.mInputLast) {
            this.loadMoreGuaranteed();
        }
        return this.mInputBuffer[this.mInputPtr++] & 0xFF;
    }

    protected void reportInvalidInitial(int mask) throws JsonParseException {
        this.reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    protected void reportInvalidOther(int mask) throws JsonParseException {
        this.reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }

    protected void reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this.mInputPtr = ptr;
        this.reportInvalidOther(mask);
    }

    public static int[] growArrayBy(int[] arr, int more) {
        if (arr == null) {
            return new int[more];
        }
        int[] old = arr;
        int len = arr.length;
        arr = new int[len + more];
        System.arraycopy(old, 0, arr, 0, len);
        return arr;
    }
}

